/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;

@Rule(key="S2122")
public class ScheduledThreadPoolExecutorZeroCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Increase the \"corePoolSize\".";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.util.concurrent.ThreadPoolExecutor").names("setCorePoolSize").addParametersMatcher("int").build(), MethodMatchers.create().ofTypes("java.util.concurrent.ScheduledThreadPoolExecutor").constructor().addParametersMatcher("int").build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        if (LiteralUtils.isZero(arg)) {
            this.reportIssue(arg, MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        ExpressionTree arg = (ExpressionTree)newClassTree.arguments().get(0);
        if (LiteralUtils.isZero(arg)) {
            this.reportIssue(arg, MESSAGE);
        }
    }
}

