/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="RightCurlyBraceStartLineCheck", repositoryKey="squid")
@Rule(key="S1109")
public class RightCurlyBraceStartLineCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER, Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER)) {
            BlockTree blockTree = (BlockTree)tree;
            this.checkBlockBody(blockTree.openBraceToken(), blockTree.closeBraceToken(), blockTree.body());
        } else {
            ClassTree classTree = (ClassTree)tree;
            this.checkBlockBody(classTree.openBraceToken(), classTree.closeBraceToken(), classTree.members());
        }
    }

    private void checkBlockBody(SyntaxToken openBraceToken, SyntaxToken closeBraceToken, List<? extends Tree> trees) {
        Tree lastTree;
        if (openBraceToken.line() != closeBraceToken.line() && !trees.isEmpty() && (lastTree = trees.get(trees.size() - 1)).lastToken().line() == closeBraceToken.line()) {
            this.reportIssue(closeBraceToken, "Move this closing curly brace to the next line.");
        }
    }
}

