/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1612")
public class ReplaceLambdaByMethodRefCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        this.visitLambdaExpression((LambdaExpressionTree)tree);
    }

    private void visitLambdaExpression(LambdaExpressionTree tree) {
        if (ReplaceLambdaByMethodRefCheck.isMethodInvocation(tree.body(), tree) || ReplaceLambdaByMethodRefCheck.isBodyBlockInvokingMethod(tree)) {
            this.reportIssue(tree.arrowToken(), "Replace this lambda with a method reference." + this.context.getJavaVersion().java8CompatibilityMessage());
        } else {
            ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf(tree).ifPresent(methodReference -> this.reportIssue(tree.arrowToken(), "Replace this lambda with method reference '" + methodReference + "'." + this.context.getJavaVersion().java8CompatibilityMessage()));
            ReplaceLambdaByMethodRefCheck.getNullCheck(tree).ifPresent(nullMethod -> this.reportIssue(tree.arrowToken(), "Replace this lambda with method reference 'Objects::" + nullMethod + "'." + this.context.getJavaVersion().java8CompatibilityMessage()));
        }
    }

    private static Optional<String> getNullCheck(LambdaExpressionTree lambda) {
        return ReplaceLambdaByMethodRefCheck.getLambdaSingleParamSymbol(lambda).flatMap(symbol -> {
            Tree lambdaBody = lambda.body();
            return ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody) ? ReplaceLambdaByMethodRefCheck.getNullCheckFromReturn(((BlockTree)lambdaBody).body().get(0), symbol) : ReplaceLambdaByMethodRefCheck.getNullCheck(lambdaBody, symbol);
        });
    }

    private static Optional<String> getNullCheckFromReturn(Tree statement, Symbol paramSymbol) {
        return statement.is(Tree.Kind.RETURN_STATEMENT) ? ReplaceLambdaByMethodRefCheck.getNullCheck(((ReturnStatementTree)statement).expression(), paramSymbol) : Optional.empty();
    }

    private static Optional<String> getNullCheck(@Nullable Tree statement, Symbol paramSymbol) {
        return ReplaceLambdaByMethodRefCheck.expressionWithoutParentheses(statement).flatMap(expr -> {
            ExpressionTree rightOperand;
            BinaryExpressionTree bet;
            ExpressionTree leftOperand;
            if (expr.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO) && (ReplaceLambdaByMethodRefCheck.nullAgainstParam(leftOperand = ExpressionUtils.skipParentheses((bet = (BinaryExpressionTree)expr).leftOperand()), rightOperand = ExpressionUtils.skipParentheses(bet.rightOperand()), paramSymbol) || ReplaceLambdaByMethodRefCheck.nullAgainstParam(rightOperand, leftOperand, paramSymbol))) {
                return Optional.of(expr.is(Tree.Kind.EQUAL_TO) ? "isNull" : "nonNull");
            }
            return Optional.empty();
        });
    }

    private static boolean nullAgainstParam(ExpressionTree o1, ExpressionTree o2, Symbol paramSymbol) {
        return o1.is(Tree.Kind.NULL_LITERAL) && o2.is(Tree.Kind.IDENTIFIER) && paramSymbol.equals(((IdentifierTree)o2).symbol());
    }

    private static Optional<String> getTypeCastOrInstanceOf(LambdaExpressionTree lambda) {
        return ReplaceLambdaByMethodRefCheck.getLambdaSingleParamSymbol(lambda).flatMap(symbol -> {
            Tree lambdaBody = lambda.body();
            return ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody) ? ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOfFromReturn(((BlockTree)lambdaBody).body().get(0), symbol) : ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf(lambdaBody, symbol);
        });
    }

    private static Optional<String> getTypeCastOrInstanceOfFromReturn(Tree statement, Symbol symbol) {
        return statement.is(Tree.Kind.RETURN_STATEMENT) ? ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf(((ReturnStatementTree)statement).expression(), symbol) : Optional.empty();
    }

    private static Optional<String> getTypeCastOrInstanceOf(@Nullable Tree statement, Symbol symbol) {
        return statement == null ? Optional.empty() : ReplaceLambdaByMethodRefCheck.expressionWithoutParentheses(statement).flatMap(expr -> ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOfName(symbol, expr));
    }

    private static Optional<String> getTypeCastOrInstanceOfName(Symbol symbol, ExpressionTree expr) {
        InstanceOfTree instanceOfTree;
        if (expr.is(Tree.Kind.TYPE_CAST)) {
            TypeCastTree typeCastTree = (TypeCastTree)expr;
            if (ReplaceLambdaByMethodRefCheck.isSingleParamExpression(typeCastTree.expression(), symbol)) {
                return ReplaceLambdaByMethodRefCheck.getTypeName(typeCastTree.type()).map(s -> s + ".class::cast");
            }
        } else if (expr.is(Tree.Kind.INSTANCE_OF) && ReplaceLambdaByMethodRefCheck.isSingleParamExpression((instanceOfTree = (InstanceOfTree)expr).expression(), symbol)) {
            return ReplaceLambdaByMethodRefCheck.getTypeName(instanceOfTree.type()).map(s -> s + ".class::isInstance");
        }
        return Optional.empty();
    }

    private static Optional<String> getTypeName(TypeTree type) {
        if (type.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            type = ((ParameterizedTypeTree)type).type();
        }
        if (type.is(Tree.Kind.IDENTIFIER) && !ReplaceLambdaByMethodRefCheck.isGeneric((IdentifierTree)type)) {
            return Optional.of(((IdentifierTree)type).name());
        }
        if (type.is(Tree.Kind.ARRAY_TYPE)) {
            return ReplaceLambdaByMethodRefCheck.getTypeName(((ArrayTypeTree)type).type()).map(x -> x + "[]");
        }
        if (type.is(Tree.Kind.PRIMITIVE_TYPE)) {
            return Optional.of(((PrimitiveTypeTree)type).keyword().text());
        }
        return Optional.empty();
    }

    private static boolean isGeneric(IdentifierTree identifierTree) {
        return JUtils.isTypeVar(identifierTree.symbolType());
    }

    private static boolean isSingleParamExpression(ExpressionTree expression, Symbol symbol) {
        return expression.is(Tree.Kind.IDENTIFIER) && symbol.equals(((IdentifierTree)expression).symbol());
    }

    private static Optional<Symbol> getLambdaSingleParamSymbol(LambdaExpressionTree tree) {
        List<VariableTree> parameters = tree.parameters();
        return parameters.size() == 1 ? Optional.of(parameters.get(0).symbol()) : Optional.empty();
    }

    private static boolean isBodyBlockInvokingMethod(LambdaExpressionTree lambdaTree) {
        Tree lambdaBody = lambdaTree.body();
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody)) {
            Tree statement = ((BlockTree)lambdaBody).body().get(0);
            return ReplaceLambdaByMethodRefCheck.isExpressionStatementInvokingMethod(statement, lambdaTree) || ReplaceLambdaByMethodRefCheck.isReturnStatementInvokingMethod(statement, lambdaTree);
        }
        return false;
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(Tree.Kind.BLOCK) && ((BlockTree)tree).body().size() == 1;
    }

    private static boolean isExpressionStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(Tree.Kind.EXPRESSION_STATEMENT) && ReplaceLambdaByMethodRefCheck.isMethodInvocation(((ExpressionStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isReturnStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(Tree.Kind.RETURN_STATEMENT) && ReplaceLambdaByMethodRefCheck.isMethodInvocation(((ReturnStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isMethodInvocation(@Nullable Tree tree, LambdaExpressionTree lambdaTree) {
        if (tree != null && tree.is(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS)) {
            Arguments arguments;
            if (tree.is(Tree.Kind.NEW_CLASS)) {
                if (((NewClassTree)tree).classBody() != null) {
                    return false;
                }
                arguments = ((NewClassTree)tree).arguments();
            } else {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (ReplaceLambdaByMethodRefCheck.hasMethodInvocationInMethodSelect(mit) || ReplaceLambdaByMethodRefCheck.hasNonFinalFieldInMethodSelect(mit)) {
                    return false;
                }
                arguments = mit.arguments();
            }
            List<VariableTree> parameters = lambdaTree.parameters();
            return ReplaceLambdaByMethodRefCheck.matchingParameters(parameters, arguments) || arguments.isEmpty() && ReplaceLambdaByMethodRefCheck.isNoArgMethodInvocationFromLambdaParam(tree, parameters);
        }
        return false;
    }

    private static boolean hasMethodInvocationInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        while (mse != null) {
            ExpressionTree expression = mse.expression();
            if (expression.is(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS)) {
                return true;
            }
            if (expression.is(Tree.Kind.MEMBER_SELECT)) {
                mse = (MemberSelectExpressionTree)expression;
                continue;
            }
            mse = null;
        }
        return false;
    }

    @CheckForNull
    private static MemberSelectExpressionTree getMemberSelect(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (!methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            return null;
        }
        return (MemberSelectExpressionTree)methodSelect;
    }

    private static boolean hasNonFinalFieldInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        if (mse == null) {
            return false;
        }
        ExpressionTree expression = ExpressionUtils.skipParentheses(mse.expression());
        Symbol symbol = null;
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            symbol = ((IdentifierTree)expression).symbol();
        } else if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            symbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
        }
        return symbol != null && symbol.owner().isTypeSymbol() && !ReplaceLambdaByMethodRefCheck.isThisOrSuper(symbol.name()) && !symbol.isFinal();
    }

    private static boolean isThisOrSuper(String name) {
        return "this".equals(name) || "super".equals(name);
    }

    private static boolean matchingParameters(List<VariableTree> parameters, Arguments arguments) {
        return arguments.size() == parameters.size() && IntStream.range(0, arguments.size()).allMatch(i -> {
            List<IdentifierTree> usages = ((VariableTree)parameters.get(i)).symbol().usages();
            return usages.size() == 1 && usages.get(0).equals(arguments.get(i));
        });
    }

    private static boolean isNoArgMethodInvocationFromLambdaParam(Tree tree, List<VariableTree> parameters) {
        if (!tree.is(Tree.Kind.METHOD_INVOCATION) || parameters.size() != 1) {
            return false;
        }
        ExpressionTree methodSelect = ((MethodInvocationTree)tree).methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            Symbol parameterSymbol = parameters.get(0).symbol();
            return expression.is(Tree.Kind.IDENTIFIER) && !parameterSymbol.isUnknown() && !ReplaceLambdaByMethodRefCheck.isAmbiguous((MethodInvocationTree)tree, parameterSymbol) && parameterSymbol.equals(((IdentifierTree)expression).symbol());
        }
        return false;
    }

    public static Optional<ExpressionTree> expressionWithoutParentheses(@Nullable Tree tree) {
        if (!(tree instanceof ExpressionTree)) {
            return Optional.empty();
        }
        ExpressionTree result = (ExpressionTree)tree;
        return Optional.of(ExpressionUtils.skipParentheses(result));
    }

    private static boolean isAmbiguous(MethodInvocationTree tree, Symbol parameterSymbol) {
        Symbol method = tree.symbol();
        Symbol.TypeSymbol methodOwner = (Symbol.TypeSymbol)method.owner();
        if (methodOwner.isUnknown() || method.isUnknown()) {
            return true;
        }
        return methodOwner.lookupSymbols(method.name()).stream().filter(Symbol::isMethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(m -> !m.isStatic() && m.parameterTypes().isEmpty() || m.isStatic() && m.parameterTypes().size() == 1 && parameterSymbol.type().isSubtypeOf(m.parameterTypes().get(0))).count() > 1L;
    }
}

