/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2156")
public class ProtectedMemberInFinalClassCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove this \"protected\" modifier.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (ModifiersUtils.hasModifier(classTree.modifiers(), Modifier.FINAL)) {
            classTree.members().forEach(this::checkMember);
        }
    }

    private void checkMember(Tree member) {
        MethodTree methodTree;
        if (member.is(Tree.Kind.VARIABLE)) {
            VariableTree variableTree = (VariableTree)member;
            this.checkVariableCompliance(variableTree);
        } else if (member.is(Tree.Kind.METHOD) && Boolean.FALSE.equals((methodTree = (MethodTree)member).isOverriding())) {
            this.checkMethodCompliance(methodTree);
        }
    }

    private void checkMethodCompliance(MethodTree methodTree) {
        this.checkComplianceOnModifiersAndSymbol(methodTree.modifiers());
    }

    private void checkVariableCompliance(VariableTree variableTree) {
        this.checkComplianceOnModifiersAndSymbol(variableTree.modifiers());
    }

    private void checkComplianceOnModifiersAndSymbol(ModifiersTree modifiers) {
        ModifierKeywordTree modifier = ModifiersUtils.getModifier(modifiers, Modifier.PROTECTED);
        if (modifier != null && !ProtectedMemberInFinalClassCheck.isVisibleForTesting(modifiers)) {
            this.reportIssue(modifier.keyword(), MESSAGE);
        }
    }

    private static boolean isVisibleForTesting(ModifiersTree modifiers) {
        return modifiers.annotations().stream().anyMatch(annotation -> "VisibleForTesting".equals(annotation.annotationType().lastToken().text()));
    }
}

