/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1174")
public class ObjectFinalizeOverridenNotPublicCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverridenNotPublicCheck.isFinalize(methodTree) && ObjectFinalizeOverridenNotPublicCheck.isPublic(methodTree)) {
            this.reportIssue(methodTree.simpleName(), "Make this finalize() method protected.");
        }
    }

    private static boolean isPublic(MethodTree methodTree) {
        return ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PUBLIC);
    }

    private static boolean isFinalize(MethodTree methodTree) {
        return "finalize".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty();
    }
}

