/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2789")
public class NullShouldNotBeUsedWithOptionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Set<String> OPTIONAL_CLASSES = SetUtils.immutableSetOf("java.util.Optional", "com.google.common.base.Optional");
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree method) {
        if (!method.is(Tree.Kind.CONSTRUCTOR) && NullShouldNotBeUsedWithOptionalCheck.returnsOptional(method)) {
            this.checkNullableAnnotation(method.modifiers(), "Methods with an \"Optional\" return type should not be \"%s\".");
            method.accept(new ReturnNullVisitor());
        }
        super.visitMethod(method);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree binaryExpression) {
        if (binaryExpression.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO)) {
            ExpressionTree left = binaryExpression.leftOperand();
            ExpressionTree right = binaryExpression.rightOperand();
            if (NullShouldNotBeUsedWithOptionalCheck.isOptional(left) && NullShouldNotBeUsedWithOptionalCheck.isNull(right) || NullShouldNotBeUsedWithOptionalCheck.isNull(left) && NullShouldNotBeUsedWithOptionalCheck.isOptional(right)) {
                this.context.reportIssue(this, binaryExpression, "Ensure this \"Optional\" could never be null and remove this null-check.");
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (NullShouldNotBeUsedWithOptionalCheck.isOptional(assignment.variable()) && NullShouldNotBeUsedWithOptionalCheck.isNull(assignment.expression())) {
            this.context.reportIssue(this, assignment.expression(), "Replace this null literal by an \"Optional\" object.");
        }
        super.visitAssignmentExpression(assignment);
    }

    @Override
    public void visitVariable(VariableTree variable) {
        if (NullShouldNotBeUsedWithOptionalCheck.isOptionalType(variable.type())) {
            this.checkNullableAnnotation(variable.modifiers(), "\"Optional\" variables should not be \"%s\".");
            ExpressionTree initializer = variable.initializer();
            if (initializer != null && NullShouldNotBeUsedWithOptionalCheck.isNull(initializer)) {
                this.context.reportIssue(this, initializer, "Replace this null literal by an \"Optional\" object.");
            }
        }
        super.visitVariable(variable);
    }

    private static boolean returnsOptional(MethodTree method) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(method.returnType());
    }

    private static boolean isOptional(ExpressionTree expression) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(expression) && !NullShouldNotBeUsedWithOptionalCheck.isNull(expression);
    }

    private static boolean isOptionalType(TypeTree type) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(type.symbolType());
    }

    private static boolean isOptionalType(ExpressionTree expression) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(expression.symbolType());
    }

    private static boolean isOptionalType(Type type) {
        return OPTIONAL_CLASSES.contains(type.fullyQualifiedName());
    }

    private static boolean isNull(ExpressionTree expression) {
        return expression.is(Tree.Kind.NULL_LITERAL);
    }

    private void checkNullableAnnotation(ModifiersTree modifiers, String messageFormat) {
        NullableAnnotationUtils.nullableAnnotation(modifiers).ifPresent(annotation -> this.context.reportIssue(this, (Tree)annotation, String.format(messageFormat, "@" + annotation.annotationType().symbolType().name())));
    }

    private class ReturnNullVisitor
    extends BaseTreeVisitor {
        private ReturnNullVisitor() {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree returnStatement) {
            this.checkNull(returnStatement.expression());
            super.visitReturnStatement(returnStatement);
        }

        @Override
        public void visitConditionalExpression(ConditionalExpressionTree conditionalExpression) {
            if (NullShouldNotBeUsedWithOptionalCheck.isOptionalType(conditionalExpression)) {
                this.checkNull(conditionalExpression.trueExpression());
                this.checkNull(conditionalExpression.falseExpression());
            }
            super.visitConditionalExpression(conditionalExpression);
        }

        private void checkNull(ExpressionTree expression) {
            if (NullShouldNotBeUsedWithOptionalCheck.isNull(expression)) {
                NullShouldNotBeUsedWithOptionalCheck.this.context.reportIssue(NullShouldNotBeUsedWithOptionalCheck.this, expression, "Methods with an \"Optional\" return type should never return null.");
            }
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }
    }
}

