/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1845")
public class MembersDifferOnlyByCapitalizationCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List<Symbol> allMembers = MembersDifferOnlyByCapitalizationCheck.retrieveMembers(classTree.symbol());
        Map<String, List<Symbol>> membersByName = allMembers.stream().collect(Collectors.groupingBy(Symbol::name));
        for (Tree member : classTree.members()) {
            if (member.is(Tree.Kind.METHOD)) {
                MethodTree methodTree = (MethodTree)member;
                this.checkForIssue(methodTree.symbol(), methodTree.simpleName(), membersByName);
                continue;
            }
            if (!member.is(Tree.Kind.VARIABLE)) continue;
            VariableTree variableTree = (VariableTree)member;
            this.checkForIssue(variableTree.symbol(), variableTree.simpleName(), membersByName);
        }
    }

    private void checkForIssue(Symbol symbol, IdentifierTree reportTree, Map<String, List<Symbol>> membersByName) {
        String name = symbol.name();
        for (Map.Entry<String, List<Symbol>> knownMemberName : membersByName.entrySet()) {
            if (!name.equalsIgnoreCase(knownMemberName.getKey())) continue;
            knownMemberName.getValue().stream().filter(knownMemberSymbol -> !symbol.equals(knownMemberSymbol) && MembersDifferOnlyByCapitalizationCheck.isValidIssueLocation(symbol, knownMemberSymbol) && MembersDifferOnlyByCapitalizationCheck.isInvalidMember(symbol, knownMemberSymbol)).findFirst().ifPresent(conflictingSymbol -> this.reportIssue(reportTree, "Rename " + MembersDifferOnlyByCapitalizationCheck.getSymbolKindName(symbol) + " \"" + name + "\" to prevent any misunderstanding/clash with " + MembersDifferOnlyByCapitalizationCheck.getSymbolKindName(conflictingSymbol) + " \"" + (String)knownMemberName.getKey() + "\"" + MembersDifferOnlyByCapitalizationCheck.getDefinitionPlace(symbol, conflictingSymbol) + "."));
        }
    }

    private static boolean isOverriding(Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            MethodTree methodDeclaration = (MethodTree)symbol.declaration();
            return methodDeclaration != null && Boolean.TRUE.equals(methodDeclaration.isOverriding());
        }
        return false;
    }

    private static boolean isInvalidMember(Symbol currentMember, Symbol knownMember) {
        if (!MembersDifferOnlyByCapitalizationCheck.isOverriding(currentMember)) {
            return MembersDifferOnlyByCapitalizationCheck.differentSymbolKinds(currentMember, knownMember) ? MembersDifferOnlyByCapitalizationCheck.invalidMethodAndVariable(currentMember, knownMember) : !MembersDifferOnlyByCapitalizationCheck.sameName(currentMember, knownMember);
        }
        return false;
    }

    private static boolean invalidMethodAndVariable(Symbol currentMember, Symbol knownMember) {
        if (!MembersDifferOnlyByCapitalizationCheck.sameVisibilityNotPrivate(currentMember, knownMember)) {
            return false;
        }
        Symbol methodSymbol = currentMember.isMethodSymbol() ? currentMember : knownMember;
        Symbol variableSymbol = methodSymbol == currentMember ? knownMember : currentMember;
        return !MembersDifferOnlyByCapitalizationCheck.methodReturningVariableWithSameName(methodSymbol, variableSymbol) && !MembersDifferOnlyByCapitalizationCheck.isBuilderPattern(methodSymbol, variableSymbol);
    }

    private static boolean isBuilderPattern(Symbol methodSymbol, Symbol variableSymbol) {
        return methodSymbol.owner().name().endsWith("Builder") && MembersDifferOnlyByCapitalizationCheck.sameName(methodSymbol, variableSymbol);
    }

    private static boolean methodReturningVariableWithSameName(Symbol methodSymbol, Symbol variableSymbol) {
        if (!MembersDifferOnlyByCapitalizationCheck.sameName(variableSymbol, methodSymbol)) {
            return false;
        }
        Tree declaration = methodSymbol.declaration();
        if (declaration != null) {
            ReturnVisitor returnVisitor = new ReturnVisitor(variableSymbol);
            declaration.accept(returnVisitor);
            return returnVisitor.singleReturnWithVariableSymbol();
        }
        return false;
    }

    private static boolean isValidIssueLocation(Symbol currentMember, Symbol knownMember) {
        return !MembersDifferOnlyByCapitalizationCheck.sameOwner(currentMember, knownMember) || MembersDifferOnlyByCapitalizationCheck.isOverriding(knownMember) || MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(currentMember) > MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(knownMember);
    }

    private static boolean sameVisibilityNotPrivate(Symbol s1, Symbol s2) {
        return MembersDifferOnlyByCapitalizationCheck.bothPublic(s1, s2) || MembersDifferOnlyByCapitalizationCheck.bothProtected(s1, s2) || MembersDifferOnlyByCapitalizationCheck.bothPackageVisibility(s1, s2);
    }

    private static boolean bothPackageVisibility(Symbol s1, Symbol s2) {
        return s1.isPackageVisibility() && s2.isPackageVisibility();
    }

    private static boolean bothProtected(Symbol s1, Symbol s2) {
        return s1.isProtected() && s2.isProtected();
    }

    private static boolean bothPublic(Symbol s1, Symbol s2) {
        return s1.isPublic() && s2.isPublic();
    }

    private static boolean sameOwner(Symbol currentMember, Symbol knownMember) {
        return currentMember.owner().equals(knownMember.owner());
    }

    private static boolean sameName(Symbol currentMember, Symbol knownMember) {
        return currentMember.name().equals(knownMember.name());
    }

    private static boolean differentSymbolKinds(Symbol s1, Symbol s2) {
        return MembersDifferOnlyByCapitalizationCheck.variableAndMethod(s1, s2) || MembersDifferOnlyByCapitalizationCheck.variableAndMethod(s2, s1);
    }

    private static boolean variableAndMethod(Symbol s1, Symbol s2) {
        return s1.isVariableSymbol() && s2.isMethodSymbol();
    }

    private static String getDefinitionPlace(Symbol symbol, Symbol knownMemberSymbol) {
        if (MembersDifferOnlyByCapitalizationCheck.sameOwner(symbol, knownMemberSymbol)) {
            int declarationLine = MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(knownMemberSymbol);
            if (declarationLine == -1) {
                return "";
            }
            return " defined on line " + declarationLine;
        }
        return " defined in " + (knownMemberSymbol.owner().isInterface() ? "interface" : "superclass") + " \"" + knownMemberSymbol.owner().type().fullyQualifiedName() + "\"";
    }

    private static int getDeclarationLine(Symbol symbol) {
        if (symbol.declaration() == null) {
            return -1;
        }
        if (symbol.isVariableSymbol()) {
            return ((Symbol.VariableSymbol)symbol).declaration().simpleName().identifierToken().line();
        }
        return ((Symbol.MethodSymbol)symbol).declaration().simpleName().identifierToken().line();
    }

    private static String getSymbolKindName(Symbol symbol) {
        return symbol.isMethodSymbol() ? "method" : "field";
    }

    private static List<Symbol> retrieveMembers(Symbol.TypeSymbol classSymbol) {
        LinkedList<Symbol> results = new LinkedList<Symbol>();
        results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(classSymbol, false));
        for (Type parentInterface : classSymbol.interfaces()) {
            results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(parentInterface.symbol(), true));
        }
        Type superClass = classSymbol.superClass();
        if (superClass != null) {
            results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(superClass.symbol(), true));
        }
        return results;
    }

    private static List<Symbol> extractMembers(Symbol.TypeSymbol classSymbol, boolean ignorePrivate) {
        LinkedList<Symbol> results = new LinkedList<Symbol>();
        for (Symbol symbol : classSymbol.memberSymbols()) {
            if (!MembersDifferOnlyByCapitalizationCheck.isVariableToExtract(symbol) && !MembersDifferOnlyByCapitalizationCheck.isMethodToExtract(symbol) || symbol.isPrivate() && ignorePrivate) continue;
            results.add(symbol);
        }
        return results;
    }

    private static boolean isVariableToExtract(Symbol symbol) {
        String name = symbol.name();
        return !symbol.isEnum() && symbol.isVariableSymbol() && !"this".equals(name) && !"super".equals(name);
    }

    private static boolean isMethodToExtract(Symbol symbol) {
        return symbol.isMethodSymbol() && !"<init>".equals(symbol.name());
    }

    private static class ReturnVisitor
    extends BaseTreeVisitor {
        private final Symbol variableSymbol;
        private boolean returnsVariable;
        private int returnCount;

        ReturnVisitor(Symbol variableSymbol) {
            this.variableSymbol = variableSymbol;
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            ++this.returnCount;
            ExpressionTree returnExpression = tree.expression();
            if (returnExpression != null && returnExpression.is(Tree.Kind.IDENTIFIER)) {
                this.returnsVariable = ((IdentifierTree)returnExpression).symbol().equals(this.variableSymbol);
            }
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitNewClass(NewClassTree tree) {
        }

        boolean singleReturnWithVariableSymbol() {
            return this.returnCount == 1 && this.returnsVariable;
        }
    }
}

