/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2164")
public class MathOnFloatCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE)) {
            if (MathOnFloatCheck.withinStringConcatenation(tree)) {
                return;
            }
            if (tree.symbolType().is("float")) {
                this.context.reportIssue(this, tree, "Use a \"double\" or \"BigDecimal\" instead.");
                return;
            }
        }
        super.visitBinaryExpression(tree);
    }

    private static boolean withinStringConcatenation(BinaryExpressionTree tree) {
        Tree parent = tree.parent();
        while (parent.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            parent = parent.parent();
        }
        return parent.is(Tree.Kind.PLUS) && ((BinaryExpressionTree)parent).symbolType().is("java.lang.String");
    }
}

