/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1075")
public class HardcodedURICheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers MATCHERS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.net.URI").constructor().addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.io.File").constructor().addParametersMatcher("java.lang.String").addParametersMatcher("*", "java.lang.String").build());
    private static final String SCHEME = "[a-zA-Z][a-zA-Z\\+\\.\\-]+";
    private static final String FOLDER_NAME = "[^/?%*:\\\\|\"<>]+";
    private static final String URI_REGEX = String.format("^%s://.+", "[a-zA-Z][a-zA-Z\\+\\.\\-]+");
    private static final String LOCAL_URI = String.format("^(~/|/|//[\\w-]+/|%s:/)(%s/)*%s/?", "[a-zA-Z][a-zA-Z\\+\\.\\-]+", "[^/?%*:\\\\|\"<>]+", "[^/?%*:\\\\|\"<>]+");
    private static final String BACKSLASH_LOCAL_URI = String.format("^(~\\\\\\\\|\\\\\\\\\\\\\\\\[\\w-]+\\\\\\\\|%s:\\\\\\\\)(%s\\\\\\\\)*%s(\\\\\\\\)?", "[a-zA-Z][a-zA-Z\\+\\.\\-]+", "[^/?%*:\\\\|\"<>]+", "[^/?%*:\\\\|\"<>]+");
    private static final String DISK_URI = "^[A-Za-z]:(/|\\\\)";
    private static final Pattern URI_PATTERN = Pattern.compile(URI_REGEX + "|" + LOCAL_URI + "|" + "^[A-Za-z]:(/|\\\\)" + "|" + BACKSLASH_LOCAL_URI);
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("filename|path", 2);
    private static final Pattern PATH_DELIMETERS_PATTERN = Pattern.compile("\"/\"|\"//\"|\"\\\\\\\\\"|\"\\\\\\\\\\\\\\\\\"");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.NEW_CLASS, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            this.checkNewClassTree((NewClassTree)tree);
        } else if (tree.is(Tree.Kind.VARIABLE)) {
            this.checkVariable((VariableTree)tree);
        } else {
            this.checkAssignment((AssignmentExpressionTree)tree);
        }
    }

    private void checkNewClassTree(NewClassTree nct) {
        if (MATCHERS.matches(nct)) {
            nct.arguments().forEach(this::checkExpression);
        }
    }

    private void checkVariable(VariableTree tree) {
        if (HardcodedURICheck.isFileNameVariable(tree.simpleName())) {
            this.checkExpression(tree.initializer());
        }
    }

    private void checkAssignment(AssignmentExpressionTree tree) {
        if (HardcodedURICheck.isFileNameVariable(HardcodedURICheck.getVariableIdentifier(tree)) && !HardcodedURICheck.isPartOfAnnotation(tree)) {
            this.checkExpression(tree.expression());
        }
    }

    private static boolean isPartOfAnnotation(AssignmentExpressionTree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(Tree.Kind.ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileNameVariable(@Nullable IdentifierTree variable) {
        return variable != null && VARIABLE_NAME_PATTERN.matcher(variable.name()).find();
    }

    private void checkExpression(@Nullable ExpressionTree expr) {
        if (expr != null) {
            if (HardcodedURICheck.isHardcodedURI(expr)) {
                this.reportHardcodedURI(expr);
            } else {
                this.reportStringConcatenationWithPathDelimiter(expr);
            }
        }
    }

    private static boolean isHardcodedURI(ExpressionTree expr) {
        ExpressionTree newExpr = ExpressionUtils.skipParentheses(expr);
        if (!newExpr.is(Tree.Kind.STRING_LITERAL)) {
            return false;
        }
        String stringLiteral = LiteralUtils.trimQuotes(((LiteralTree)newExpr).value());
        return URI_PATTERN.matcher(stringLiteral).find();
    }

    private void reportHardcodedURI(ExpressionTree hardcodedURI) {
        this.reportIssue(hardcodedURI, "Refactor your code to get this URI from a customizable parameter.");
    }

    private void reportStringConcatenationWithPathDelimiter(ExpressionTree expr) {
        expr.accept(new StringConcatenationVisitor());
    }

    @CheckForNull
    private static IdentifierTree getVariableIdentifier(AssignmentExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)variable;
        }
        if (variable.is(Tree.Kind.MEMBER_SELECT)) {
            return ((MemberSelectExpressionTree)variable).identifier();
        }
        return null;
    }

    private class StringConcatenationVisitor
    extends BaseTreeVisitor {
        private StringConcatenationVisitor() {
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(Tree.Kind.PLUS)) {
                this.checkPathDelimiter(tree.leftOperand());
                this.checkPathDelimiter(tree.rightOperand());
            }
            super.visitBinaryExpression(tree);
        }

        private void checkPathDelimiter(ExpressionTree expr) {
            ExpressionTree newExpr = ExpressionUtils.skipParentheses(expr);
            if (newExpr.is(Tree.Kind.STRING_LITERAL) && PATH_DELIMETERS_PATTERN.matcher(((LiteralTree)newExpr).value()).find()) {
                HardcodedURICheck.this.reportIssue(newExpr, "Remove this hard-coded path-delimiter.");
            }
        }
    }
}

