/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4454")
public class EqualsParametersMarkedNonNullCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        VariableTree variable;
        MethodTree methodTree = (MethodTree)tree;
        List<VariableTree> params = methodTree.parameters();
        if ("equals".equals(methodTree.symbol().name()) && params.size() == 1 && (variable = params.get(0)).type().symbolType().is("java.lang.Object") && NullableAnnotationUtils.isAnnotatedNonNull(variable.symbol())) {
            this.reportIssue(variable, "\"equals\" method parameters should not be marked \"@Nonnull\".");
        }
    }
}

