/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1186")
public class EmptyMethodsCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ModifiersUtils.hasModifier(classTree.modifiers(), Modifier.ABSTRACT)) {
            List<Tree> members = classTree.members();
            this.checkMethods(members);
            this.checkSingleNoArgPublicConstructor(members);
        }
    }

    private void checkMethods(List<Tree> members) {
        members.stream().filter(member -> member.is(Tree.Kind.METHOD)).map(MethodTree.class::cast).forEach(this::checkMethod);
    }

    private void checkSingleNoArgPublicConstructor(List<Tree> members) {
        List constructors = members.stream().filter(member -> member.is(Tree.Kind.CONSTRUCTOR)).map(MethodTree.class::cast).collect(Collectors.toList());
        if (constructors.size() == 1 && EmptyMethodsCheck.isPublicNoArgConstructor((MethodTree)constructors.get(0))) {
            this.checkMethod((MethodTree)constructors.get(0));
        }
    }

    private static boolean isPublicNoArgConstructor(MethodTree constructor) {
        return ModifiersUtils.hasModifier(constructor.modifiers(), Modifier.PUBLIC) && constructor.parameters().isEmpty();
    }

    private void checkMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && EmptyMethodsCheck.isEmpty(block) && !EmptyMethodsCheck.containsComment(block)) {
            this.reportIssue(methodTree.simpleName(), "Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.");
        }
    }

    private static boolean isEmpty(BlockTree block) {
        List<StatementTree> body = block.body();
        return body.isEmpty() || body.stream().allMatch(stmt -> stmt.is(Tree.Kind.EMPTY_STATEMENT));
    }

    private static boolean containsComment(BlockTree block) {
        return !block.closeBraceToken().trivias().isEmpty();
    }
}

