/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1170")
public class ConstantsShouldBeStaticFinalCheck
extends IssuableSubscriptionVisitor {
    private int nestedClassesLevel;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.nestedClassesLevel = 0;
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        ++this.nestedClassesLevel;
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTree variableTree;
            if (!member.is(Tree.Kind.VARIABLE) || !ConstantsShouldBeStaticFinalCheck.staticNonFinal(variableTree = (VariableTree)member) || !ConstantsShouldBeStaticFinalCheck.hasConstantInitializer(variableTree) || this.isObjectInInnerClass(variableTree)) continue;
            this.reportIssue(variableTree.simpleName(), "Make this final field static too.");
        }
    }

    private boolean isObjectInInnerClass(VariableTree variableTree) {
        if (this.nestedClassesLevel > 1) {
            ExpressionTree initializer = variableTree.initializer();
            return !variableTree.type().is(Tree.Kind.PRIMITIVE_TYPE) && !variableTree.symbol().type().is("java.lang.String") || initializer == null || !initializer.asConstant().isPresent();
        }
        return false;
    }

    private static boolean staticNonFinal(VariableTree variableTree) {
        return ConstantsShouldBeStaticFinalCheck.isFinal(variableTree) && !ConstantsShouldBeStaticFinalCheck.isStatic(variableTree);
    }

    @Override
    public void leaveNode(Tree tree) {
        --this.nestedClassesLevel;
    }

    private static boolean hasConstantInitializer(VariableTree variableTree) {
        ExpressionTree init = variableTree.initializer();
        if (init != null) {
            MethodReferenceTree methodRef;
            if (ExpressionUtils.skipParentheses(init).is(Tree.Kind.METHOD_REFERENCE) && ConstantsShouldBeStaticFinalCheck.isInstanceIdentifier((methodRef = (MethodReferenceTree)ExpressionUtils.skipParentheses(init)).expression())) {
                return false;
            }
            if (init.is(Tree.Kind.NEW_ARRAY)) {
                return false;
            }
            return !ConstantsShouldBeStaticFinalCheck.containsChildMatchingPredicate((JavaTree)((Object)init), tree -> ConstantsShouldBeStaticFinalCheck.isIgnoredKind(tree) || ConstantsShouldBeStaticFinalCheck.isThisOrSuper(tree));
        }
        return false;
    }

    private static boolean isIgnoredKind(Tree tree) {
        return tree.is(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    private static boolean isThisOrSuper(Tree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            String name = ((IdentifierTree)tree).name();
            return "super".equals(name) || "this".equals(name);
        }
        return false;
    }

    private static boolean isInstanceIdentifier(Tree expression) {
        return expression.is(Tree.Kind.IDENTIFIER) && !((IdentifierTree)expression).symbol().isStatic();
    }

    private static boolean containsChildMatchingPredicate(JavaTree tree, Predicate<Tree> predicate) {
        if (predicate.test(tree)) {
            return true;
        }
        if (!tree.isLeaf()) {
            for (Tree javaTree : tree.getChildren()) {
                if (javaTree == null || !ConstantsShouldBeStaticFinalCheck.containsChildMatchingPredicate((JavaTree)javaTree, predicate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFinal(VariableTree variableTree) {
        return ModifiersUtils.hasModifier(variableTree.modifiers(), Modifier.FINAL);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return ModifiersUtils.hasModifier(variableTree.modifiers(), Modifier.STATIC);
    }
}

