/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3972")
public class ConditionalOnNewLineCheck
extends IssuableSubscriptionVisitor {
    private SyntaxToken previousToken;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.previousToken = null;
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        StatementTree elsePart;
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        if (this.previousToken != null && this.isOnSameLineAsPreviousIf(ifStatementTree)) {
            this.reportIssue(ifStatementTree.ifKeyword(), "Move this \"if\" to a new line or add the missing \"else\".", Collections.singletonList(new JavaFileScannerContext.Location("", this.previousToken)), null);
        }
        this.previousToken = (elsePart = ifStatementTree.elseStatement()) != null ? elsePart.lastToken() : ifStatementTree.thenStatement().lastToken();
    }

    private boolean isOnSameLineAsPreviousIf(IfStatementTree ifStatementTree) {
        return this.previousToken.line() == ifStatementTree.ifKeyword().line() && this.previousToken.column() < ifStatementTree.ifKeyword().column();
    }
}

