/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1820")
public class ClassFieldCountCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_THRESHOLD = 20;
    private static final boolean DEFAULT_COUNT_NON_PUBLIC_FIELDS = true;
    @RuleProperty(key="maximumFieldThreshold", description="The maximum number of fields", defaultValue="20")
    private int threshold = 20;
    @RuleProperty(key="countNonpublicFields", description="Whether or not to include non-public fields in the count", defaultValue="true")
    private boolean countNonPublicFields = true;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        long fieldCount = classTree.members().stream().filter(member -> member.is(Tree.Kind.VARIABLE) && this.shouldBeCounted((VariableTree)member)).count();
        if (fieldCount > (long)this.threshold) {
            String message = String.format("Refactor this class so it has no more than %d %sfields, rather than the %d it currently has.", this.threshold, this.countNonPublicFields ? "" : "public ", fieldCount);
            this.reportIssue(ExpressionsHelper.reportOnClassTree(classTree), message);
        }
    }

    private boolean shouldBeCounted(VariableTree variableTree) {
        Symbol symbol = variableTree.symbol();
        if (symbol.isStatic() && symbol.isFinal()) {
            return false;
        }
        return this.countNonPublicFields || symbol.isPublic();
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setCountNonPublicFields(boolean countNonPublicFields) {
        this.countNonPublicFields = countNonPublicFields;
    }
}

