/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S1696")
public class CatchNPECheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitCatch(CatchTree tree) {
        super.visitCatch(tree);
        TypeTree typeTree = tree.parameter().type();
        if (typeTree.is(Tree.Kind.UNION_TYPE)) {
            ((UnionTypeTree)typeTree).typeAlternatives().forEach(this::checkType);
        } else {
            this.checkType(typeTree);
        }
    }

    private void checkType(Tree tree) {
        MemberSelectExpressionTree memberSelectTree;
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)tree;
            if (CatchNPECheck.isNPE(identifier.name())) {
                this.addIssue(identifier);
            }
        } else if (tree.is(Tree.Kind.MEMBER_SELECT) && CatchNPECheck.isNPE((memberSelectTree = (MemberSelectExpressionTree)tree).identifier().name())) {
            this.checkJavaLangNPE(memberSelectTree);
        }
    }

    private void checkJavaLangNPE(MemberSelectExpressionTree memberSelectTree) {
        MemberSelectExpressionTree mse;
        ExpressionTree expression = memberSelectTree.expression();
        if (expression.is(Tree.Kind.MEMBER_SELECT) && "lang".equals((mse = (MemberSelectExpressionTree)expression).identifier().name()) && mse.expression().is(Tree.Kind.IDENTIFIER) && "java".equals(((IdentifierTree)mse.expression()).name())) {
            this.addIssue(memberSelectTree.identifier());
        }
    }

    private static boolean isNPE(String name) {
        return "NullPointerException".equals(name);
    }

    private void addIssue(IdentifierTree tree) {
        this.context.reportIssue(this, tree, "Avoid catching NullPointerException.");
    }
}

