/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2647")
public class BasicAuthCheck
extends AbstractMethodDetection {
    private static final String LANG_STRING = "java.lang.String";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes("org.apache.http.message.AbstractHttpMessage").names("setHeader").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("org.apache.http.message.AbstractHttpMessage").names("addHeader").addParametersMatcher(LANG_STRING, LANG_STRING).build(), MethodMatchers.create().ofSubTypes("org.apache.http.message.BasicHeader").constructor().addParametersMatcher(LANG_STRING, LANG_STRING).build(), MethodMatchers.create().ofSubTypes("java.net.URLConnection").names("setRequestProperty").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("java.net.URLConnection").names("addRequestProperty").withAnyParameters().build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.checkArguments(mit.arguments());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkArguments(newClassTree.arguments());
    }

    private void checkArguments(Arguments arguments) {
        ExpressionTree arg;
        String authentication;
        if ("Authorization".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value()) && (authentication = ExpressionsHelper.getConstantValueAsString(arg = BasicAuthCheck.mostLeft((ExpressionTree)arguments.get(1))).value()) != null && authentication.startsWith("Basic")) {
            this.reportIssue(arg, "Use a more secure method than basic authentication.");
        }
    }

    private static ExpressionTree mostLeft(ExpressionTree arg) {
        ExpressionTree res = ExpressionUtils.skipParentheses(arg);
        while (res.is(Tree.Kind.PLUS)) {
            res = ExpressionUtils.skipParentheses(((BinaryExpressionTree)res).leftOperand());
        }
        return res;
    }
}

