/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.CFGLoop;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S2189")
public class NoWayOutLoopCheck
extends SECheck {
    private static final MethodMatchers THREAD_RUN_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"run"}).addWithoutParametersMatcher().build();
    private final Deque<MethodContext> contexts = new LinkedList<MethodContext>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.contexts.clear();
    }

    @Override
    public void init(MethodTree tree, CFG cfg) {
        MethodContext context = new MethodContext(tree, cfg);
        this.contexts.push(context);
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        if (this.contexts.peek().isThreadRunMethod()) {
            return context.getState();
        }
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        context.alwaysTrueOrFalseExpressions().alwaysTrue().forEach(tree -> {
            Tree statementParent = NoWayOutLoopCheck.firstStatementParent(tree);
            if (statementParent != null && statementParent.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT})) {
                this.checkLoopWithAlwaysTrueCondition(context, statementParent);
            }
        });
        this.contexts.pop();
    }

    private void checkLoopWithAlwaysTrueCondition(CheckerContext context, Tree statementParent) {
        CFGLoop loopBlocks = this.contexts.peek().getLoop(statementParent);
        if (loopBlocks != null && loopBlocks.hasNoWayOut()) {
            context.reportIssue(statementParent, this, "Add an end condition to this loop.");
        }
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.contexts.pop();
    }

    @CheckForNull
    private static Tree firstStatementParent(Tree node) {
        Tree current;
        for (current = node.parent(); current != null && !(current instanceof StatementTree); current = current.parent()) {
        }
        return current;
    }

    private static class MethodContext {
        private final Map<Tree, CFGLoop> loopStarts;
        private final boolean threadRunMethod;

        MethodContext(MethodTree tree, CFG cfg) {
            this.loopStarts = CFGLoop.getCFGLoops((CFG)cfg);
            this.threadRunMethod = THREAD_RUN_MATCHER.matches(tree);
        }

        boolean isThreadRunMethod() {
            return this.threadRunMethod;
        }

        CFGLoop getLoop(Tree tree) {
            return this.loopStarts.get(tree);
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;

        protected PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.visitLoopCondition(tree.condition(), (Tree)tree);
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.visitLoopCondition(tree.condition(), (Tree)tree);
        }

        private void visitLoopCondition(ExpressionTree condition, Tree tree) {
            if (LiteralUtils.isTrue((Tree)condition)) {
                NoWayOutLoopCheck.this.checkLoopWithAlwaysTrueCondition(this.context, tree);
            }
        }

        public void visitForStatement(ForStatementTree tree) {
            if (tree.condition() == null) {
                NoWayOutLoopCheck.this.checkLoopWithAlwaysTrueCondition(this.context, (Tree)tree);
            } else if (this.isConditionUnreachable(tree)) {
                this.context.reportIssue((Tree)tree, NoWayOutLoopCheck.this, "Correct this loop's end condition.");
            }
        }

        private boolean isConditionUnreachable(ForStatementTree tree) {
            UpdatesCollector collector = new UpdatesCollector();
            tree.accept((TreeVisitor)collector);
            ConditionType condition = new ConditionType(tree.condition(), collector);
            return !condition.isMatched();
        }
    }

    private static class UpdatesCollector
    extends BaseTreeVisitor
    implements Iterable<Update> {
        private List<Update> updates = new ArrayList<Update>();

        private UpdatesCollector() {
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan((Tree)tree.condition());
            this.scan(tree.update());
            this.scan((Tree)tree.statement());
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree assign = tree.variable();
            if (assign.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                UpdateType type = tree.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT}) ? UpdateType.INCREMENT : (tree.is(new Tree.Kind[]{Tree.Kind.MINUS_ASSIGNMENT}) ? UpdateType.DECREMENT : UpdateType.INDETERMINATE);
                this.updates.add(new Update(((IdentifierTree)assign).symbol(), type));
            }
            super.visitAssignmentExpression(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree expression) {
            ExpressionTree unary = expression.expression();
            if (unary.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)unary).symbol();
                if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT})) {
                    this.updates.add(new Update(symbol, UpdateType.INCREMENT));
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                    this.updates.add(new Update(symbol, UpdateType.DECREMENT));
                }
            }
            super.visitUnaryExpression(expression);
        }

        @Override
        public Iterator<Update> iterator() {
            return this.updates.iterator();
        }
    }

    private static class ConditionType {
        private final boolean matched;

        public ConditionType(ExpressionTree condition, UpdatesCollector collector) {
            this.matched = condition.is(new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO}) ? this.canBeMatched(((BinaryExpressionTree)condition).leftOperand(), ((BinaryExpressionTree)condition).rightOperand(), collector) : (condition.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) ? this.canBeMatched(((BinaryExpressionTree)condition).rightOperand(), ((BinaryExpressionTree)condition).leftOperand(), collector) : true);
        }

        protected boolean canBeMatched(ExpressionTree leftOperand, ExpressionTree rightOperand, UpdatesCollector collector) {
            boolean matchFound = false;
            for (Update update : collector) {
                if (update.concerns(leftOperand)) {
                    if (!UpdateType.DECREMENT.equals((Object)update.type())) {
                        return true;
                    }
                    matchFound = true;
                }
                if (!update.concerns(rightOperand)) continue;
                if (!UpdateType.INCREMENT.equals((Object)update.type())) {
                    return true;
                }
                matchFound = true;
            }
            return !matchFound;
        }

        public boolean isMatched() {
            return this.matched;
        }
    }

    private static class Update {
        private Symbol symbol = null;
        private UpdateType type = null;

        Update(Symbol symbol, UpdateType type) {
            this.symbol = symbol;
            this.type = type;
        }

        UpdateType type() {
            return this.type;
        }

        boolean concerns(ExpressionTree operand) {
            if (operand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return this.symbol.equals((Object)((IdentifierTree)operand).symbol());
            }
            if (operand.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT})) {
                UnaryExpressionTree unary = (UnaryExpressionTree)operand;
                return this.concerns(unary.expression());
            }
            return false;
        }
    }

    private static enum UpdateType {
        INCREMENT,
        DECREMENT,
        INDETERMINATE;

    }
}

