/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.XxeProcessingCheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public abstract class AbstractXMLProcessing
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    protected abstract MethodMatchers getParsingMethods();

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ProgramState endState = context.getState();
        if (endState.exitingOnRuntimeException()) {
            return;
        }
        SymbolicValue peek = endState.peekValue();
        if (peek instanceof XxeProcessingCheck.XxeSymbolicValue) {
            XxeProcessingCheck.XxeSymbolicValue xxeSV = (XxeProcessingCheck.XxeSymbolicValue)peek;
            this.reportIfNotSecured(context, xxeSV, endState.getConstraints(xxeSV));
        }
    }

    private void reportIfNotSecured(CheckerContext context, XxeProcessingCheck.XxeSymbolicValue xxeSV, @Nullable ConstraintsByDomain constraintsByDomain) {
        if (!xxeSV.isField && this.isUnSecuredByProperty(constraintsByDomain)) {
            context.reportIssue(this.getIssueLocation(context, xxeSV), this, this.getMessage());
        }
    }

    protected abstract boolean isUnSecuredByProperty(@Nullable ConstraintsByDomain var1);

    protected abstract String getMessage();

    protected abstract boolean shouldTrackConstraint(Constraint var1);

    protected abstract List<Class<? extends Constraint>> getDomains();

    private Tree getIssueLocation(CheckerContext context, XxeProcessingCheck.XxeSymbolicValue xxeSV) {
        return FlowComputation.flowWithoutExceptions(context.getNode(), xxeSV, this::shouldTrackConstraint, this.getDomains(), 1).stream().findFirst().flatMap(f -> f.elements().stream().findFirst()).map(e -> e.syntaxNode).orElse(xxeSV.init);
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;

        private PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            SymbolicValue peek;
            if (AbstractXMLProcessing.this.getParsingMethods().matches(mit) && (peek = this.programState.peekValue(mit.arguments().size())) instanceof XxeProcessingCheck.XxeSymbolicValue) {
                XxeProcessingCheck.XxeSymbolicValue xxeSymbolicValue = (XxeProcessingCheck.XxeSymbolicValue)peek;
                AbstractXMLProcessing.this.reportIfNotSecured(this.context, xxeSymbolicValue, this.programState.getConstraints(xxeSymbolicValue));
            }
        }
    }
}

