/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.checks.CustomUnclosedResourcesCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.StreamConsumedCheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonarsource.analyzer.commons.collections.PCollections;
import org.sonarsource.analyzer.commons.collections.PMap;
import org.sonarsource.analyzer.commons.collections.PStack;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class ProgramState {
    private static final Set<Class<? extends Constraint>> NON_DISPOSABLE_CONSTRAINTS = SetUtils.immutableSetOf((Object[])new Class[]{UnclosedResourcesCheck.ResourceConstraint.class, CustomUnclosedResourcesCheck.CustomResourceConstraint.class, LocksNotUnlockedCheck.LockConstraint.class, StreamConsumedCheck.StreamPipelineConstraint.class});
    private Set<RelationalSymbolicValue> knownRelations;
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState((PMap<Symbol, SymbolicValue>)PCollections.emptyMap(), (PMap<SymbolicValue, Integer>)PCollections.emptyMap(), (PMap<SymbolicValue, ConstraintsByDomain>)PCollections.emptyMap().put((Object)SymbolicValue.NULL_LITERAL, (Object)ConstraintsByDomain.empty().put(ObjectConstraint.NULL)).put((Object)SymbolicValue.TRUE_LITERAL, (Object)ConstraintsByDomain.empty().put(BooleanConstraint.TRUE).put(ObjectConstraint.NOT_NULL)).put((Object)SymbolicValue.FALSE_LITERAL, (Object)ConstraintsByDomain.empty().put(BooleanConstraint.FALSE).put(ObjectConstraint.NOT_NULL)), (PMap<ProgramPoint, Integer>)PCollections.emptyMap(), (PStack<SymbolicValueSymbol>)PCollections.emptyStack(), null, null);
    private final PMap<ProgramPoint, Integer> visitedPoints;
    private final PStack<SymbolicValueSymbol> stack;
    @Nullable
    private SymbolicValue.ExceptionalSymbolicValue entryException;
    private final PMap<SymbolicValue, Integer> references;
    private SymbolicValue exitSymbolicValue;
    final PMap<Symbol, SymbolicValue> values;
    final PMap<Integer, SymbolicValue> valuesByIndex;
    final PMap<SymbolicValue, ConstraintsByDomain> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<Integer, SymbolicValue> valuesByIndex, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, ConstraintsByDomain> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValueSymbol> stack, SymbolicValue exitSymbolicValue, @Nullable SymbolicValue.ExceptionalSymbolicValue entryException) {
        this.values = values;
        this.valuesByIndex = valuesByIndex;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.entryException = entryException;
        this.constraintSize = 3;
    }

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, ConstraintsByDomain> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValueSymbol> stack, SymbolicValue exitSymbolicValue, @Nullable SymbolicValue.ExceptionalSymbolicValue entryException) {
        this.values = values;
        this.valuesByIndex = PCollections.emptyMap();
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.entryException = entryException;
        this.constraintSize = 3;
    }

    private ProgramState(ProgramState ps, PStack<SymbolicValueSymbol> newStack) {
        this.values = ps.values;
        this.valuesByIndex = ps.valuesByIndex;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = newStack;
        this.entryException = ps.entryException;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, ConstraintsByDomain> newConstraints) {
        this.values = ps.values;
        this.valuesByIndex = ps.valuesByIndex;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = ps.stack;
        this.entryException = ps.entryException;
    }

    public ProgramState withEntryException(@Nullable SymbolicValue.ExceptionalSymbolicValue exception) {
        return new ProgramState(this.values, this.valuesByIndex, this.references, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue, exception);
    }

    @CheckForNull
    public SymbolicValue.ExceptionalSymbolicValue getEntryException() {
        return this.entryException;
    }

    public ProgramState stackValue(SymbolicValue sv) {
        return new ProgramState(this, (PStack<SymbolicValueSymbol>)this.stack.push((Object)new SymbolicValueSymbol(sv, null)));
    }

    public ProgramState stackValue(SymbolicValue sv, @Nullable Symbol symbol) {
        return new ProgramState(this, (PStack<SymbolicValueSymbol>)this.stack.push((Object)new SymbolicValueSymbol(sv, symbol)));
    }

    ProgramState clearStack() {
        return this.stack.isEmpty() ? this : new ProgramState(this, (PStack<SymbolicValueSymbol>)PCollections.emptyStack());
    }

    public Pop unstackValue(int nbElements) {
        if (nbElements == 0 || this.stack.isEmpty()) {
            return new Pop(this, Collections.emptyList());
        }
        PStack newStack = this.stack;
        ArrayList<SymbolicValueSymbol> result = new ArrayList<SymbolicValueSymbol>();
        for (int i = 0; i < nbElements && !newStack.isEmpty(); ++i) {
            result.add((SymbolicValueSymbol)newStack.peek());
            newStack = newStack.pop();
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    @CheckForNull
    public SymbolicValue peekValue() {
        return this.stack.isEmpty() ? null : ((SymbolicValueSymbol)this.stack.peek()).sv;
    }

    public SymbolicValueSymbol peekValueSymbol() {
        return (SymbolicValueSymbol)this.stack.peek();
    }

    public SymbolicValue peekValue(int i) {
        return ((SymbolicValueSymbol)this.stack.peek((int)i)).sv;
    }

    public List<SymbolicValue> peekValues(int n) {
        return this.peekValuesAndSymbols(n).stream().map(SymbolicValueSymbol::symbolicValue).collect(Collectors.toList());
    }

    public List<SymbolicValueSymbol> peekValuesAndSymbols(int n) {
        ArrayList<SymbolicValueSymbol> result = new ArrayList<SymbolicValueSymbol>();
        PStack tmpStack = this.stack;
        for (int i = 0; i < n; ++i) {
            result.add((SymbolicValueSymbol)tmpStack.peek());
            tmpStack = tmpStack.pop();
        }
        return Collections.unmodifiableList(result);
    }

    public int numberOfTimeVisited(ProgramPoint programPoint) {
        Integer count = (Integer)this.visitedPoints.get((Object)programPoint);
        return count == null ? 0 : count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.exitSymbolicValue, that.exitSymbolicValue) && Objects.equals(this.stack, that.stack);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "} { " + this.stack.toString() + " }";
    }

    public ProgramState addConstraintTransitively(SymbolicValue symbolicValue, Constraint constraint) {
        List transitiveSymbolicValues = this.knownRelations().stream().filter(rsv -> rsv.isEquality() && (rsv.getLeftOp() == symbolicValue || rsv.getRightOp() == symbolicValue)).map(rsv -> rsv.getLeftOp() == symbolicValue ? rsv.getRightOp() : rsv.getLeftOp()).collect(Collectors.toList());
        ProgramState ps = this.addConstraint(symbolicValue, constraint);
        for (SymbolicValue sv : transitiveSymbolicValues) {
            ps = ps.addConstraint(sv, constraint);
        }
        return ps;
    }

    public Set<RelationalSymbolicValue> knownRelations() {
        if (this.knownRelations == null) {
            this.knownRelations = Collections.unmodifiableSet(this.getValuesWithConstraints(BooleanConstraint.TRUE).stream().filter(RelationalSymbolicValue.class::isInstance).map(RelationalSymbolicValue.class::cast).collect(Collectors.toSet()));
        }
        return this.knownRelations;
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Constraint constraint) {
        Preconditions.checkState((!(symbolicValue instanceof RelationalSymbolicValue) || constraint != BooleanConstraint.FALSE ? 1 : 0) != 0, (String)"Relations stored in PS should always use TRUE constraint. SV: %s", (Object)symbolicValue);
        ConstraintsByDomain constraintsForSV = (ConstraintsByDomain)this.constraints.get((Object)symbolicValue);
        if (constraintsForSV == null) {
            constraintsForSV = ConstraintsByDomain.empty();
        }
        return this.addConstraints(symbolicValue, constraintsForSV.put(constraint));
    }

    public ProgramState addConstraints(SymbolicValue symbolicValue, ConstraintsByDomain constraintsForSV) {
        PMap newConstraints = this.constraints.put((Object)symbolicValue, (Object)constraintsForSV);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, (PMap<SymbolicValue, ConstraintsByDomain>)newConstraints);
        }
        return this;
    }

    public ProgramState removeConstraintsOnDomain(SymbolicValue sv, Class<? extends Constraint> domain) {
        ConstraintsByDomain svConstraint = (ConstraintsByDomain)this.constraints.get((Object)sv);
        if (svConstraint == null) {
            return this;
        }
        ConstraintsByDomain newConstraintForSv = svConstraint.remove(domain);
        if (newConstraintForSv.isEmpty()) {
            return new ProgramState(this, (PMap<SymbolicValue, ConstraintsByDomain>)this.constraints.remove((Object)sv));
        }
        return this.addConstraints(sv, newConstraintForSv);
    }

    @VisibleForTesting
    public ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown() || ProgramState.isVolatileField(symbol)) {
            return this;
        }
        SymbolicValue oldValue = (SymbolicValue)this.values.get((Object)symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap newValues = this.values.put((Object)symbol, (Object)value);
            return new ProgramState((PMap<Symbol, SymbolicValue>)newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue, this.entryException);
        }
        return this;
    }

    private static boolean isVolatileField(Symbol symbol) {
        return ProgramState.isField(symbol) && symbol.isVolatile();
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = (Integer)givenReferences.get((Object)sv);
        Objects.requireNonNull(value);
        return givenReferences.put((Object)sv, (Object)(value - 1));
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = (Integer)givenReferences.get((Object)sv);
        if (value == null) {
            return givenReferences.put((Object)sv, (Object)1);
        }
        return givenReferences.put((Object)sv, (Object)(value + 1));
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Constraint constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !NON_DISPOSABLE_CONSTRAINTS.contains(constraint.getClass()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable ConstraintsByDomain constraints) {
        if (!SymbolicValue.isDisposable(symbolicValue)) return false;
        if (constraints == null) return true;
        if (!NON_DISPOSABLE_CONSTRAINTS.stream().map(constraints::get).allMatch(Objects::isNull)) return false;
        return true;
    }

    private static boolean inStack(PStack<SymbolicValueSymbol> stack, SymbolicValue symbolicValue) {
        return stack.anyMatch(valueSymbol -> valueSymbol.sv.equals(symbolicValue) || valueSymbol.sv.references(symbolicValue));
    }

    public ProgramState cleanupDeadSymbols(final Set<Symbol> liveVariables, final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<Symbol, SymbolicValue> {
            boolean newProgramState = false;
            PMap<Symbol, SymbolicValue> newValues;
            PMap<SymbolicValue, Integer> newReferences;
            PMap<SymbolicValue, ConstraintsByDomain> newConstraints;

            CleanAction() {
                this.newValues = ProgramState.this.values;
                this.newReferences = ProgramState.this.references;
                this.newConstraints = ProgramState.this.constraints;
            }

            @Override
            public void accept(Symbol symbol, SymbolicValue symbolicValue) {
                if (JUtils.isLocalVariable((Symbol)symbol) && !liveVariables.contains(symbol) && !protectedSymbolicValues.contains(symbolicValue)) {
                    this.newProgramState = true;
                    this.newValues = this.newValues.remove((Object)symbol);
                    this.newReferences = ProgramState.decreaseReference(this.newReferences, symbolicValue);
                    if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, (ConstraintsByDomain)this.newConstraints.get((Object)symbolicValue)) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newConstraints = this.newConstraints.remove((Object)symbolicValue);
                        this.newReferences = this.newReferences.remove((Object)symbolicValue);
                    }
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.values.forEach((BiConsumer)cleanAction);
        return cleanAction.newProgramState ? new ProgramState(cleanAction.newValues, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue, this.entryException) : this;
    }

    public ProgramState cleanupConstraints(final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<SymbolicValue, ConstraintsByDomain> {
            boolean newProgramState = false;
            PMap<SymbolicValue, ConstraintsByDomain> newConstraints;
            PMap<SymbolicValue, Integer> newReferences;

            CleanAction() {
                this.newConstraints = ProgramState.this.constraints;
                this.newReferences = ProgramState.this.references;
            }

            @Override
            public void accept(SymbolicValue symbolicValue, ConstraintsByDomain constraintPMap) {
                constraintPMap.forEach((domain, constraint) -> {
                    if (!protectedSymbolicValues.contains(symbolicValue) && !ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, constraint) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newProgramState = true;
                        ConstraintsByDomain removed = ((ConstraintsByDomain)this.newConstraints.get((Object)symbolicValue)).remove((Class<? extends Constraint>)domain);
                        this.newConstraints = removed.isEmpty() ? this.newConstraints.remove((Object)symbolicValue) : this.newConstraints.put((Object)symbolicValue, (Object)removed);
                        this.newReferences = this.newReferences.remove((Object)symbolicValue);
                    }
                });
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.constraints.forEach((BiConsumer)cleanAction);
        return cleanAction.newProgramState ? new ProgramState(this.values, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue, this.entryException) : this;
    }

    ProgramState resetFieldValues(ConstraintManager constraintManager, boolean resetOnlyStaticFields) {
        ArrayList fields = new ArrayList();
        this.values.forEach((symbol, symbolicValue) -> {
            if (ProgramState.isField(symbol) && !symbol.isFinal() && (symbol.isStatic() || !resetOnlyStaticFields)) {
                fields.add(symbol);
            }
        });
        ProgramState newProgramState = this;
        for (Symbol field : fields) {
            newProgramState = newProgramState.put(field, constraintManager.createDefaultSymbolicValue());
        }
        return newProgramState;
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = (Integer)references.get((Object)symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.valuesByIndex, this.references, this.constraints, (PMap<ProgramPoint, Integer>)this.visitedPoints.put((Object)programPoint, (Object)nbOfVisit), this.stack, this.exitSymbolicValue, this.entryException);
    }

    @Nullable
    public ConstraintsByDomain getConstraints(SymbolicValue sv) {
        return (ConstraintsByDomain)this.constraints.get((Object)sv);
    }

    @CheckForNull
    public <T extends Constraint> T getConstraint(SymbolicValue sv, Class<T> domain) {
        ConstraintsByDomain classConstraintPMap = (ConstraintsByDomain)this.constraints.get((Object)sv);
        if (classConstraintPMap == null) {
            return null;
        }
        return (T)classConstraintPMap.get(domain);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(int index) {
        return (SymbolicValue)this.valuesByIndex.get((Object)index);
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return (SymbolicValue)this.values.get((Object)symbol);
    }

    public List<SymbolicValue> getValuesWithConstraints(Constraint constraint) {
        ArrayList<SymbolicValue> result = new ArrayList<SymbolicValue>();
        this.constraints.forEach((symbolicValue, constraintByDomain) -> {
            Constraint find = constraintByDomain.get(constraint.getClass());
            if (constraint.equals(find)) {
                result.add((SymbolicValue)symbolicValue);
            }
        });
        return result;
    }

    public void storeExitValue() {
        this.storeExitValue(this.peekValue());
    }

    public void storeExitValue(@Nullable SymbolicValue exitSymbolicValue) {
        this.exitSymbolicValue = exitSymbolicValue;
    }

    @CheckForNull
    public SymbolicValue exitValue() {
        return this.exitSymbolicValue;
    }

    public boolean exitingOnRuntimeException() {
        if (this.exitSymbolicValue instanceof SymbolicValue.ExceptionalSymbolicValue) {
            Type exceptionType = ((SymbolicValue.ExceptionalSymbolicValue)this.exitSymbolicValue).exceptionType();
            return exceptionType == null || exceptionType.isUnknown() || exceptionType.isSubtypeOf("java.lang.RuntimeException");
        }
        return false;
    }

    Set<LearnedConstraint> learnedConstraints(ProgramState parent) {
        HashSet result = new HashSet();
        this.constraints.forEach((sv, pmap) -> pmap.forEach((domain, c) -> {
            if (!c.equals(parent.getConstraint((SymbolicValue)sv, (Class)domain))) {
                result.add(new LearnedConstraint((SymbolicValue)sv, (Constraint)c));
            }
        }));
        return Collections.unmodifiableSet(result);
    }

    Set<LearnedAssociation> learnedAssociations(ProgramState parent) {
        HashSet result = new HashSet();
        this.values.forEach((s, sv) -> {
            if (parent.getValue((Symbol)s) != sv) {
                result.add(new LearnedAssociation((SymbolicValue)sv, (Symbol)s));
            }
        });
        return Collections.unmodifiableSet(result);
    }

    public static class SymbolicValueSymbol {
        final SymbolicValue sv;
        @Nullable
        final Symbol symbol;

        public SymbolicValueSymbol(SymbolicValue sv, @Nullable Symbol symbol) {
            this.sv = sv;
            this.symbol = symbol;
        }

        public SymbolicValue symbolicValue() {
            return this.sv;
        }

        public Symbol symbol() {
            return this.symbol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymbolicValueSymbol that = (SymbolicValueSymbol)o;
            return Objects.equals(this.sv, that.sv);
        }

        public int hashCode() {
            return Objects.hash(this.sv);
        }

        public String toString() {
            return this.symbol == null ? this.sv.toString() : this.symbol.toString() + "->" + this.sv.toString();
        }
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;
        public final List<SymbolicValueSymbol> valuesAndSymbols;

        public Pop(ProgramState programState, List<SymbolicValueSymbol> result) {
            this.state = programState;
            this.values = result.stream().map(SymbolicValueSymbol::symbolicValue).collect(Collectors.toList());
            this.valuesAndSymbols = result;
        }
    }
}

