/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.data;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.surefire.data.UnitTestClassReport;

public class UnitTestIndex {
    private Map<String, UnitTestClassReport> indexByClassname = new HashMap<String, UnitTestClassReport>();

    public UnitTestClassReport index(String classname) {
        return this.indexByClassname.computeIfAbsent(classname, name -> new UnitTestClassReport());
    }

    public UnitTestClassReport get(String classname) {
        return this.indexByClassname.get(classname);
    }

    public Set<String> getClassnames() {
        return Sets.newHashSet(this.indexByClassname.keySet());
    }

    public Map<String, UnitTestClassReport> getIndexByClassname() {
        return this.indexByClassname;
    }

    public int size() {
        return this.indexByClassname.size();
    }

    public UnitTestClassReport merge(String classname, String intoClassname) {
        UnitTestClassReport from = this.indexByClassname.get(classname);
        if (from != null) {
            UnitTestClassReport to = this.index(intoClassname);
            to.add(from);
            this.indexByClassname.remove(classname);
            return to;
        }
        return null;
    }

    public void remove(String classname) {
        this.indexByClassname.remove(classname);
    }
}

