/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.surefire.SurefireJavaParser;
import org.sonar.plugins.surefire.api.SurefireUtils;

@DependedUpon(value={"surefire-java"})
public class SurefireSensor
implements Sensor {
    private static final Logger LOGGER = Loggers.get(SurefireSensor.class);
    private final SurefireJavaParser surefireJavaParser;
    private final Settings settings;
    private final FileSystem fs;
    private final PathResolver pathResolver;

    public SurefireSensor(SurefireJavaParser surefireJavaParser, Settings settings, FileSystem fs, PathResolver pathResolver) {
        this.surefireJavaParser = surefireJavaParser;
        this.settings = settings;
        this.fs = fs;
        this.pathResolver = pathResolver;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("SurefireSensor");
    }

    public void execute(SensorContext context) {
        List<File> dirs = SurefireUtils.getReportsDirectories(this.settings, this.fs, this.pathResolver);
        this.collect(context, dirs);
    }

    protected void collect(SensorContext context, List<File> reportsDirs) {
        LOGGER.info("parsing {}", reportsDirs);
        this.surefireJavaParser.collect(context, reportsDirs, this.settings.hasKey("sonar.junit.reportPaths") || this.settings.hasKey("sonar.junit.reportsPath"));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

