/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.java.annotations.Beta;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.SourceMap;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

@Beta
public interface JavaFileScannerContext
extends InputFileScannerContext {
    public CompilationUnitTree getTree();

    @Nullable
    public Object getSemanticModel();

    public boolean fileParsed();

    public List<Tree> getComplexityNodes(Tree var1);

    public void reportIssue(JavaCheck var1, Tree var2, String var3);

    public void reportIssue(JavaCheck var1, Tree var2, String var3, List<Location> var4, @Nullable Integer var5);

    public void reportIssueWithFlow(JavaCheck var1, Tree var2, String var3, Iterable<List<Location>> var4, @Nullable Integer var5);

    public void reportIssue(JavaCheck var1, Tree var2, Tree var3, String var4);

    public void reportIssue(JavaCheck var1, Tree var2, Tree var3, String var4, List<Location> var5, @Nullable Integer var6);

    public List<String> getFileLines();

    public String getFileContent();

    default public Optional<SourceMap> sourceMap() {
        return Optional.empty();
    }

    public static class Location {
        public final String msg;
        public final Tree syntaxNode;

        public Location(String msg, Tree syntaxNode) {
            this.msg = msg;
            this.syntaxNode = Objects.requireNonNull(syntaxNode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return Objects.equals(this.msg, location.msg) && Objects.equals(this.syntaxNode, location.syntaxNode);
        }

        public int hashCode() {
            return Objects.hash(this.msg, this.syntaxNode);
        }
    }
}

