/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.java.ast.parser.ListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ModifiersTreeImpl
extends ListTreeImpl<ModifierTree>
implements ModifiersTree {
    private final List<ModifierKeywordTree> modifiers;
    private final List<AnnotationTree> annotations;

    public ModifiersTreeImpl(List<ModifierTree> javaTrees) {
        super(javaTrees);
        ArrayList<ModifierKeywordTree> modifiersList = new ArrayList<ModifierKeywordTree>();
        ArrayList<AnnotationTree> annotationsList = new ArrayList<AnnotationTree>();
        for (ModifierTree modifierTree : this) {
            if (modifierTree.is(Tree.Kind.ANNOTATION)) {
                annotationsList.add((AnnotationTree)modifierTree);
                continue;
            }
            modifiersList.add((ModifierKeywordTree)modifierTree);
        }
        this.annotations = Collections.unmodifiableList(annotationsList);
        this.modifiers = Collections.unmodifiableList(modifiersList);
    }

    public static ModifiersTreeImpl emptyModifiers() {
        return new ModifiersTreeImpl(Collections.emptyList());
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.MODIFIERS;
    }

    @Override
    public List<ModifierKeywordTree> modifiers() {
        return this.modifiers;
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitModifier(this);
    }
}

