/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonar.api.batch.fs.InputFile;

public final class InputFileUtils {
    private InputFileUtils() {
    }

    public static String md5Hash(InputFile inputFile) {
        String contents;
        try {
            contents = inputFile.contents();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return InputFileUtils.hash(contents.getBytes(inputFile.charset()), "MD5", 32);
    }

    public static String hash(byte[] input, String algorithm, int expectedLength) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(algorithm + " not supported", e);
        }
        md.update(input);
        String suffix = new BigInteger(1, md.digest()).toString(16);
        String prefix = "0".repeat(expectedLength - suffix.length());
        return prefix + suffix;
    }
}

