/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class PublicApiChecker {
    private static final Tree.Kind[] CLASS_KINDS = new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD};
    private static final Tree.Kind[] METHOD_KINDS = new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR};
    private static final Tree.Kind[] API_KINDS = ListUtils.concat((List[])new List[]{Arrays.asList(CLASS_KINDS), Arrays.asList(METHOD_KINDS), Collections.singletonList(Tree.Kind.VARIABLE)}).toArray(new Tree.Kind[0]);

    private PublicApiChecker() {
    }

    public static Tree.Kind[] classKinds() {
        return (Tree.Kind[])CLASS_KINDS.clone();
    }

    public static Tree.Kind[] methodKinds() {
        return (Tree.Kind[])METHOD_KINDS.clone();
    }

    public static Tree.Kind[] apiKinds() {
        return (Tree.Kind[])API_KINDS.clone();
    }

    public static boolean isPublicApi(@Nullable Tree currentParent, Tree tree) {
        if (currentParent == null || currentParent.is(Tree.Kind.COMPILATION_UNIT)) {
            return tree.is(CLASS_KINDS) && PublicApiChecker.isPublicApi(null, (ClassTree)tree);
        }
        if (tree.is(CLASS_KINDS) && currentParent.is(CLASS_KINDS)) {
            return PublicApiChecker.isPublicApi((ClassTree)currentParent, (ClassTree)tree);
        }
        if (tree.is(METHOD_KINDS)) {
            return PublicApiChecker.isPublicApi((ClassTree)currentParent, (MethodTree)tree);
        }
        if (tree.is(Tree.Kind.VARIABLE) && !currentParent.is(METHOD_KINDS)) {
            return PublicApiChecker.isPublicApi((ClassTree)currentParent, (VariableTree)tree);
        }
        return false;
    }

    private static boolean isPublicApi(@Nullable ClassTree currentClass, ClassTree classTree) {
        return currentClass != null && PublicApiChecker.isPublicInterface(currentClass) || PublicApiChecker.hasPublic(classTree.modifiers());
    }

    private static boolean isPublicInterface(ClassTree currentClass) {
        return currentClass.is(Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE) && !ModifiersUtils.hasModifier(currentClass.modifiers(), Modifier.PRIVATE);
    }

    private static boolean hasPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC);
    }

    private static boolean isPublicApi(ClassTree classTree, MethodTree methodTree) {
        Objects.requireNonNull(classTree);
        if (PublicApiChecker.isPublicInterface(classTree)) {
            return !Boolean.TRUE.equals(methodTree.isOverriding());
        }
        if (PublicApiChecker.isEmptyDefaultConstructor(methodTree) || Boolean.TRUE.equals(methodTree.isOverriding()) && !PublicApiChecker.isDefaultConstructor(methodTree) || classTree.is(Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE) || PublicApiChecker.constructorOfNonPublicClass(methodTree, classTree)) {
            return false;
        }
        return PublicApiChecker.hasPublic(methodTree.modifiers());
    }

    private static boolean constructorOfNonPublicClass(MethodTree methodTree, ClassTree classTree) {
        return methodTree.is(Tree.Kind.CONSTRUCTOR) && !PublicApiChecker.hasPublic(classTree.modifiers());
    }

    private static boolean isEmptyDefaultConstructor(MethodTree methodTree) {
        return PublicApiChecker.isDefaultConstructor(methodTree) && methodTree.block().body().isEmpty();
    }

    private static boolean isDefaultConstructor(MethodTree methodTree) {
        return methodTree.is(Tree.Kind.CONSTRUCTOR) && methodTree.parameters().isEmpty();
    }

    private static boolean isPublicApi(ClassTree classTree, VariableTree variableTree) {
        return !PublicApiChecker.isPublicInterface(classTree) && !PublicApiChecker.isStaticFinal(variableTree) && PublicApiChecker.hasPublic(variableTree.modifiers());
    }

    private static boolean isStaticFinal(VariableTree variableTree) {
        return ModifiersUtils.hasAll(variableTree.modifiers(), Modifier.STATIC, Modifier.FINAL);
    }

    public static Optional<String> getApiJavadoc(Tree tree) {
        if (!tree.is(API_KINDS)) {
            return Optional.empty();
        }
        return tree.firstToken().trivias().stream().map(SyntaxTrivia::comment).filter(PublicApiChecker::isJavadoc).reduce((first, second) -> second);
    }

    private static boolean isJavadoc(String comment) {
        return comment.startsWith("/**");
    }
}

