/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaIssue;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JspCodeVisitor;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class SonarComponents {
    private static final Logger LOG = Loggers.get(SonarComponents.class);
    private static final int LOGGED_MAX_NUMBER_UNDEFINED_TYPES = 50;
    public static final String FAIL_ON_EXCEPTION_KEY = "sonar.internal.analysis.failFast";
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ClasspathForMain javaClasspath;
    private final ClasspathForTest javaTestClasspath;
    private final Set<String> undefinedTypes = new HashSet<String>();
    private final CheckFactory checkFactory;
    @Nullable
    private final ProjectDefinition projectDefinition;
    private final FileSystem fs;
    private final List<Checks<JavaCheck>> checks;
    private final List<Checks<JavaCheck>> testChecks;
    private final List<Checks<JavaCheck>> allChecks;
    private SensorContext context;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, checkRegistrars, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable ProjectDefinition projectDefinition) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, projectDefinition);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars, @Nullable ProjectDefinition projectDefinition) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.projectDefinition = projectDefinition;
        this.checks = new ArrayList<Checks<JavaCheck>>();
        this.testChecks = new ArrayList<Checks<JavaCheck>>();
        this.allChecks = new ArrayList<Checks<JavaCheck>>();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                List<Class<? extends JavaCheck>> checkClasses = SonarComponents.getChecks(registrarContext.checkClasses());
                List<Class<? extends JavaCheck>> testCheckClasses = SonarComponents.getChecks(registrarContext.testCheckClasses());
                this.registerCheckClasses(registrarContext.repositoryKey(), checkClasses);
                this.registerTestCheckClasses(registrarContext.repositoryKey(), testCheckClasses);
            }
        }
    }

    private static List<Class<? extends JavaCheck>> getChecks(@Nullable Iterable<Class<? extends JavaCheck>> iterable) {
        return iterable != null ? StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()) : Collections.emptyList();
    }

    public void setSensorContext(SensorContext context) {
        this.context = context;
    }

    public FileLinesContext fileLinesContextFor(InputFile inputFile) {
        return this.fileLinesContextFactory.createFor(inputFile);
    }

    public NewSymbolTable symbolizableFor(InputFile inputFile) {
        return this.context.newSymbolTable().onFile(inputFile);
    }

    public NewHighlighting highlightableFor(InputFile inputFile) {
        Objects.requireNonNull(this.context);
        return this.context.newHighlighting().onFile(inputFile);
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return new ArrayList<File>();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public List<File> getJspClasspath() {
        ArrayList<File> jspClasspath = new ArrayList<File>();
        jspClasspath.add(SonarComponents.findPluginJar());
        jspClasspath.addAll(this.getJavaClasspath());
        return jspClasspath;
    }

    private static File findPluginJar() {
        try {
            return new File(SonarComponents.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to obtain plugin jar.", e);
        }
    }

    public void registerCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.checks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public JavaCheck[] checkClasses() {
        return (JavaCheck[])this.checks.stream().flatMap(ce -> ce.all().stream()).toArray(JavaCheck[]::new);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return this.allChecks;
    }

    public void registerTestCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.testChecks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public Collection<JavaCheck> testCheckClasses() {
        ArrayList<JavaCheck> visitors = new ArrayList<JavaCheck>();
        for (Checks<JavaCheck> checksElement : this.testChecks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors;
    }

    public List<JavaCheck> jspCodeVisitors() {
        return this.allChecks.stream().flatMap(javaChecks -> javaChecks.all().stream()).filter(JspCodeVisitor.class::isInstance).collect(Collectors.toList());
    }

    public RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks()) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    public void addIssue(InputComponent inputComponent, JavaCheck check, int line, String message, @Nullable Integer cost) {
        this.reportIssue(new AnalyzerMessage(check, inputComponent, line, message, cost != null ? cost : 0));
    }

    public void reportIssue(AnalyzerMessage analyzerMessage) {
        JavaCheck check = analyzerMessage.getCheck();
        Objects.requireNonNull(check);
        Objects.requireNonNull(analyzerMessage.getMessage());
        RuleKey key = this.getRuleKey(check);
        if (key == null) {
            return;
        }
        InputComponent inputComponent = analyzerMessage.getInputComponent();
        if (inputComponent == null) {
            return;
        }
        Double cost = analyzerMessage.getCost();
        this.reportIssue(analyzerMessage, key, inputComponent, cost);
    }

    @VisibleForTesting
    void reportIssue(AnalyzerMessage analyzerMessage, RuleKey key, InputComponent fileOrProject, @Nullable Double cost) {
        Objects.requireNonNull(this.context);
        JavaIssue issue = JavaIssue.create(this.context, key, cost);
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        if (textSpan == null) {
            issue.setPrimaryLocationOnComponent(fileOrProject, analyzerMessage.getMessage());
        } else {
            if (!textSpan.onLine()) {
                Preconditions.checkState(!textSpan.isEmpty(), "Issue location should not be empty");
            }
            issue.setPrimaryLocation((InputFile)fileOrProject, analyzerMessage.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        if (!analyzerMessage.flows.isEmpty()) {
            issue.addFlow((InputFile)analyzerMessage.getInputComponent(), analyzerMessage.flows);
        }
        issue.save();
    }

    public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
        this.reportAnalysisError(inputFile, re.getMessage());
        return this.isSonarLintContext();
    }

    private void reportAnalysisError(InputFile inputFile, String message) {
        this.context.newAnalysisError().onFile(inputFile).message(message).save();
    }

    public boolean isSonarLintContext() {
        return this.context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    public List<String> fileLines(InputFile inputFile) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
        }
        return lines;
    }

    public String inputFileContents(InputFile inputFile) {
        try {
            return inputFile.contents();
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
        }
    }

    public boolean analysisCancelled() {
        return this.context.isCancelled();
    }

    public boolean shouldFailAnalysisOnException() {
        return this.context.config().getBoolean(FAIL_ON_EXCEPTION_KEY).orElse(false);
    }

    public File workDir() {
        ProjectDefinition current = this.projectDefinition;
        if (current == null) {
            return this.fs.workDir();
        }
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current.getWorkDir();
    }

    public InputComponent project() {
        return this.context.project();
    }

    public void collectUndefinedTypes(Set<String> undefinedTypes) {
        this.undefinedTypes.addAll(undefinedTypes);
    }

    public void logUndefinedTypes() {
        if (!this.undefinedTypes.isEmpty()) {
            this.javaClasspath.logSuspiciousEmptyLibraries();
            this.javaTestClasspath.logSuspiciousEmptyLibraries();
            this.logUndefinedTypes(50);
            this.undefinedTypes.clear();
        }
    }

    private void logUndefinedTypes(int maxLines) {
        boolean moreThanMax = this.undefinedTypes.size() > maxLines;
        String warningMessage = "Unresolved imports/types have been detected during analysis. Enable DEBUG mode to see them.";
        String debugMessage = moreThanMax ? String.format("First %d unresolved imports/types:", maxLines) : "Unresolved imports/types:";
        String delimiter = System.lineSeparator() + "- ";
        String prefix = debugMessage + delimiter;
        String suffix = moreThanMax ? delimiter + "..." : "";
        LOG.warn(warningMessage);
        LOG.debug(this.undefinedTypes.stream().sorted().limit(maxLines).collect(Collectors.joining(delimiter, prefix, suffix)));
    }
}

