/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.java.ast.visitors.CognitiveComplexityVisitor;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.ast.visitors.StatementVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class Measurer
extends SubscriptionVisitor {
    private final SensorContext sensorContext;
    private final NoSonarFilter noSonarFilter;
    private InputFile sonarFile;
    private int methods;
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private int classes;

    public Measurer(SensorContext context, NoSonarFilter noSonarFilter) {
        this.sensorContext = context;
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD, Tree.Kind.NEW_CLASS, Tree.Kind.ENUM_CONSTANT, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.sonarFile = context.getInputFile();
        CommentLinesVisitor commentLinesVisitor = this.createCommentLineVisitorAndFindNoSonar(context);
        if (this.isSonarLintContext()) {
            return;
        }
        this.classTrees.clear();
        this.methods = 0;
        this.classes = 0;
        super.setContext(context);
        this.scanTree(context.getTree());
        int fileComplexity = context.getComplexityNodes(context.getTree()).size();
        this.saveMetricOnFile(CoreMetrics.CLASSES, this.classes);
        this.saveMetricOnFile(CoreMetrics.FUNCTIONS, this.methods);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, commentLinesVisitor.commentLinesMetric());
        this.saveMetricOnFile(CoreMetrics.STATEMENTS, new StatementVisitor().numberOfStatements(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodeVisitor().linesOfCode(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.COGNITIVE_COMPLEXITY, CognitiveComplexityVisitor.compilationUnitComplexity(context.getTree()));
    }

    private boolean isSonarLintContext() {
        return this.sensorContext.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    private CommentLinesVisitor createCommentLineVisitorAndFindNoSonar(JavaFileScannerContext context) {
        CommentLinesVisitor commentLinesVisitor = new CommentLinesVisitor();
        commentLinesVisitor.analyzeCommentLines(context.getTree());
        this.noSonarFilter.noSonarInFile(this.sonarFile, commentLinesVisitor.noSonarLines());
        return commentLinesVisitor;
    }

    @Override
    public void visitNode(Tree tree) {
        if (Measurer.isClassTree(tree)) {
            ++this.classes;
            this.classTrees.push((ClassTree)tree);
        }
        if (tree.is(Tree.Kind.NEW_CLASS) && ((NewClassTree)tree).classBody() != null) {
            --this.classes;
        }
        if (tree.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR) && this.classTrees.peek().simpleName() != null) {
            ++this.methods;
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (Measurer.isClassTree(tree)) {
            this.classTrees.pop();
        }
    }

    private static boolean isClassTree(Tree tree) {
        return tree.is(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD);
    }

    private <T extends Serializable> void saveMetricOnFile(Metric<T> metric, T value) {
        this.sensorContext.newMeasure().forMetric(metric).on((InputComponent)this.sonarFile).withValue(value).save();
    }

    public class TestFileMeasurer
    implements JavaFileScanner {
        @Override
        public void scanFile(JavaFileScannerContext context) {
            Measurer.this.sonarFile = context.getInputFile();
            Measurer.this.createCommentLineVisitorAndFindNoSonar(context);
        }
    }
}

