/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.constraint.Constraint;

public class ConstraintsByDomain {
    private final PMap<Class<? extends Constraint>, Constraint> constraintPMap;
    private static final ConstraintsByDomain EMPTY = new ConstraintsByDomain(PCollections.emptyMap());

    private ConstraintsByDomain(PMap<Class<? extends Constraint>, Constraint> constraintPMap) {
        this.constraintPMap = constraintPMap;
    }

    public static ConstraintsByDomain empty() {
        return EMPTY;
    }

    public ConstraintsByDomain remove(Class<? extends Constraint> domain) {
        PMap<Class<? extends Constraint>, Constraint> remove = this.constraintPMap.remove(domain);
        if (remove == this.constraintPMap) {
            return this;
        }
        return remove.isEmpty() ? EMPTY : new ConstraintsByDomain(remove);
    }

    @Nullable
    public Constraint get(Class<? extends Constraint> domain) {
        return this.constraintPMap.get(domain);
    }

    public boolean hasConstraint(Constraint constraint) {
        return constraint.equals(this.constraintPMap.get(constraint.getClass()));
    }

    public void forEach(BiConsumer<Class<? extends Constraint>, Constraint> action) {
        this.constraintPMap.forEach(action);
    }

    public boolean isEmpty() {
        return this.constraintPMap.isEmpty();
    }

    public ConstraintsByDomain put(Constraint constraint) {
        PMap<Class<? extends Constraint>, Constraint> newConstraints = this.constraintPMap.put(constraint.getClass(), constraint);
        return newConstraints == this.constraintPMap ? this : new ConstraintsByDomain(newConstraints);
    }

    public Stream<Constraint> stream() {
        Stream.Builder builder = Stream.builder();
        this.constraintPMap.forEach((K d, V constraint) -> builder.add(constraint));
        return builder.build();
    }

    public Stream<Class<? extends Constraint>> domains() {
        Stream.Builder builder = Stream.builder();
        this.constraintPMap.forEach((K domain, V constraint) -> builder.add(domain));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintsByDomain that = (ConstraintsByDomain)o;
        return this.constraintPMap.equals(that.constraintPMap);
    }

    public String toString() {
        return this.stream().map(Object::toString).sorted().collect(Collectors.joining(",", "[", "]"));
    }

    public int hashCode() {
        return this.constraintPMap.hashCode();
    }
}

