/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class UnicodeCodePointTree
extends CharacterTree {
    private final int codePoint;

    public UnicodeCodePointTree(RegexSource source, IndexRange range, int codePoint) {
        super(source, range);
        this.codePoint = codePoint;
    }

    @Override
    public int codePointOrUnit() {
        return this.codePoint;
    }

    @Override
    public boolean isEscapeSequence() {
        return true;
    }

    @Override
    public String characterAsString() {
        return String.valueOf(Character.toChars(this.codePoint));
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitUnicodeCodePoint(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.UNICODE_CODE_POINT;
    }
}

