/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.CheckForNull;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexSource;

public class SimpleQuantifier
extends Quantifier {
    private final Kind kind;

    public SimpleQuantifier(RegexSource source, IndexRange range, Quantifier.Modifier modifier, Kind kind) {
        super(source, range, modifier);
        this.kind = kind;
    }

    @Override
    public int getMinimumRepetitions() {
        if (this.kind == Kind.PLUS) {
            return 1;
        }
        return 0;
    }

    @Override
    @CheckForNull
    public Integer getMaximumRepetitions() {
        if (this.kind == Kind.QUESTION_MARK) {
            return 1;
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        STAR("*"),
        PLUS("+"),
        QUESTION_MARK("?");

        private final String str;

        private Kind(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

