/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class LookAroundTree
extends GroupTree {
    private final Polarity polarity;
    private final Direction direction;

    public LookAroundTree(RegexSource source, IndexRange range, Polarity polarity, Direction direction, RegexTree element) {
        super(source, RegexTree.Kind.LOOK_AROUND, element, range);
        this.polarity = polarity;
        this.direction = direction;
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitLookAround(this);
    }

    public static LookAroundTree positiveLookAhead(RegexSource source, IndexRange range, RegexTree element) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.AHEAD, element);
    }

    public static LookAroundTree negativeLookAhead(RegexSource source, IndexRange range, RegexTree element) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.AHEAD, element);
    }

    public static LookAroundTree positiveLookBehind(RegexSource source, IndexRange range, RegexTree element) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.BEHIND, element);
    }

    public static LookAroundTree negativeLookBehind(RegexSource source, IndexRange range, RegexTree element) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.BEHIND, element);
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }

    public static enum Direction {
        AHEAD,
        BEHIND;

    }
}

