/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.java.regex.ast.JavaCharacter;

public class FlagSet {
    private int mask;
    private final Map<Integer, JavaCharacter> flagCharacters;

    public FlagSet() {
        this(0);
    }

    public FlagSet(FlagSet other) {
        this.mask = other.mask;
        this.flagCharacters = new HashMap<Integer, JavaCharacter>(other.flagCharacters);
    }

    public FlagSet(int initialFlags) {
        this.flagCharacters = new HashMap<Integer, JavaCharacter>();
        this.mask = 0;
        this.add(initialFlags);
    }

    public boolean contains(int flag) {
        return (this.mask & flag) != 0;
    }

    @CheckForNull
    public JavaCharacter getJavaCharacterForFlag(int flag) {
        return this.flagCharacters.get(flag);
    }

    public void add(int flag) {
        if ((flag & 0x100) != 0) {
            this.mask |= 0x40;
        }
        this.mask |= flag;
    }

    public void add(int flag, JavaCharacter character) {
        this.add(flag);
        this.flagCharacters.put(flag, character);
    }

    public void addAll(FlagSet other) {
        this.mask |= other.mask;
        this.flagCharacters.putAll(other.flagCharacters);
    }

    public void removeAll(FlagSet other) {
        this.mask &= ~other.mask;
        this.flagCharacters.keySet().removeAll(other.flagCharacters.keySet());
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isEmpty() {
        return this.mask == 0;
    }
}

