/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.Nullable;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class BackReferenceTree
extends RegexTree {
    private final String groupName;
    @Nullable
    private final JavaCharacter key;

    public BackReferenceTree(RegexSource source, JavaCharacter backslash, @Nullable JavaCharacter key, JavaCharacter start, JavaCharacter end) {
        super(source, backslash.getRange().merge(end.getRange()));
        this.key = key;
        this.groupName = start.getCharacter() != '<' ? source.substringAt(start.getRange().merge(end.getRange())) : source.substringAt(new IndexRange(start.getRange().getBeginningOffset() + 1, end.getRange().getBeginningOffset()));
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitBackReference(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.BACK_REFERENCE;
    }

    public boolean isNamedGroup() {
        return this.key != null;
    }

    public boolean isNumerical() {
        return this.key == null;
    }

    public String groupName() {
        return this.groupName;
    }

    public int groupNumber() {
        if (!this.isNumerical()) {
            return -1;
        }
        return Integer.parseInt(this.groupName);
    }
}

