/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.sonar.java.ast.parser.BlockStatementListTreeImpl;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class CaseGroupTreeImpl
extends JavaTree
implements CaseGroupTree {
    private final List<CaseLabelTree> labels;
    private final List<StatementTree> body;

    public CaseGroupTreeImpl(List<CaseLabelTreeImpl> labels, BlockStatementListTreeImpl body) {
        this.labels = ImmutableList.builder().addAll((Iterable)Objects.requireNonNull(labels)).build();
        this.body = Objects.requireNonNull(body);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.CASE_GROUP;
    }

    @Override
    public List<CaseLabelTree> labels() {
        return this.labels;
    }

    @Override
    public List<StatementTree> body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCaseGroup(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Iterables.concat(this.labels, this.body);
    }
}

