/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class LambdaExpressionTreeImpl
extends AssessableExpressionTree
implements LambdaExpressionTree {
    @Nullable
    private final InternalSyntaxToken openParenToken;
    private final List<VariableTree> parameters;
    @Nullable
    private final InternalSyntaxToken closeParenToken;
    private final InternalSyntaxToken arrowToken;
    private final Tree body;

    public LambdaExpressionTreeImpl(@Nullable InternalSyntaxToken openParenToken, List<VariableTree> parameters, @Nullable InternalSyntaxToken closeParenToken, InternalSyntaxToken arrowToken, Tree body) {
        this.openParenToken = openParenToken;
        this.parameters = parameters;
        this.closeParenToken = closeParenToken;
        this.arrowToken = arrowToken;
        this.body = body;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.LAMBDA_EXPRESSION;
    }

    @Override
    @Nullable
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public List<VariableTree> parameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public SyntaxToken arrowToken() {
        return this.arrowToken;
    }

    @Override
    public Tree body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLambdaExpression(this);
    }

    @Override
    public Iterable<Tree> children() {
        boolean hasParentheses = this.openParenToken != null;
        return Iterables.concat(hasParentheses ? Collections.singletonList(this.openParenToken) : Collections.emptyList(), this.parameters, hasParentheses ? Collections.singletonList(this.closeParenToken) : Collections.emptyList(), (Iterable)Lists.newArrayList((Object[])new Tree[]{this.arrowToken, this.body}));
    }
}

