/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.AnalysisException;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaIssue;
import org.sonar.java.JavaTestClasspath;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JspCodeVisitor;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class SonarComponents {
    public static final String FAIL_ON_EXCEPTION_KEY = "sonar.internal.analysis.failFast";
    private final FileLinesContextFactory fileLinesContextFactory;
    private final JavaTestClasspath javaTestClasspath;
    private final CheckFactory checkFactory;
    @Nullable
    private final ProjectDefinition projectDefinition;
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    private final List<Checks<JavaCheck>> checks;
    private final List<Checks<JavaCheck>> testChecks;
    private final List<Checks<JavaCheck>> allChecks;
    private final SonarJavaIssueFilter issueFilter;
    private SensorContext context;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, SonarJavaIssueFilter postAnalysisIssueFilter) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, null, postAnalysisIssueFilter);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars, SonarJavaIssueFilter postAnalysisIssueFilter) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, checkRegistrars, null, postAnalysisIssueFilter);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable ProjectDefinition projectDefinition, SonarJavaIssueFilter postAnalysisIssueFilter) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, projectDefinition, postAnalysisIssueFilter);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars, @Nullable ProjectDefinition projectDefinition, SonarJavaIssueFilter postAnalysisIssueFilter) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.projectDefinition = projectDefinition;
        this.checks = new ArrayList<Checks<JavaCheck>>();
        this.testChecks = new ArrayList<Checks<JavaCheck>>();
        this.allChecks = new ArrayList<Checks<JavaCheck>>();
        this.issueFilter = postAnalysisIssueFilter;
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                ArrayList checkClasses = registrarContext.checkClasses();
                ArrayList testCheckClasses = registrarContext.testCheckClasses();
                this.registerCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(checkClasses != null ? checkClasses : new ArrayList())));
                this.registerTestCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(testCheckClasses != null ? testCheckClasses : new ArrayList())));
            }
        }
    }

    public void setSensorContext(SensorContext context) {
        this.context = context;
    }

    public FileLinesContext fileLinesContextFor(InputFile inputFile) {
        return this.fileLinesContextFactory.createFor(inputFile);
    }

    public NewSymbolTable symbolizableFor(InputFile inputFile) {
        return this.context.newSymbolTable().onFile(inputFile);
    }

    public NewHighlighting highlightableFor(InputFile inputFile) {
        Objects.requireNonNull(this.context);
        return this.context.newHighlighting().onFile(inputFile);
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return new ArrayList<File>();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public List<File> getJspClasspath() {
        ArrayList<File> jspClasspath = new ArrayList<File>();
        jspClasspath.add(SonarComponents.findPluginJar());
        jspClasspath.addAll(this.getJavaClasspath());
        return jspClasspath;
    }

    private static File findPluginJar() {
        try {
            return new File(SonarComponents.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to obtain plugin jar.", e);
        }
    }

    public void registerCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.checks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public JavaCheck[] checkClasses() {
        return (JavaCheck[])this.checks.stream().flatMap(ce -> ce.all().stream()).toArray(JavaCheck[]::new);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return this.allChecks;
    }

    public void registerTestCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.testChecks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public Collection<JavaCheck> testCheckClasses() {
        ArrayList<JavaCheck> visitors = new ArrayList<JavaCheck>();
        for (Checks<JavaCheck> checksElement : this.testChecks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors;
    }

    public List<JavaCheck> jspCodeVisitors() {
        return this.allChecks.stream().flatMap(javaChecks -> javaChecks.all().stream()).filter(check -> check instanceof JspCodeVisitor).collect(Collectors.toList());
    }

    public RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks()) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    public void addIssue(InputComponent inputComponent, JavaCheck check, int line, String message, @Nullable Integer cost) {
        this.reportIssue(new AnalyzerMessage(check, inputComponent, line, message, cost != null ? cost : 0));
    }

    public void reportIssue(AnalyzerMessage analyzerMessage) {
        JavaCheck check = analyzerMessage.getCheck();
        Objects.requireNonNull(check);
        Objects.requireNonNull(analyzerMessage.getMessage());
        RuleKey key = this.getRuleKey(check);
        if (key == null) {
            return;
        }
        InputComponent inputComponent = analyzerMessage.getInputComponent();
        if (inputComponent == null) {
            return;
        }
        if (this.issueFilter != null && !this.issueFilter.accept(key, analyzerMessage)) {
            return;
        }
        Double cost = analyzerMessage.getCost();
        this.reportIssue(analyzerMessage, key, inputComponent, cost);
    }

    @VisibleForTesting
    void reportIssue(AnalyzerMessage analyzerMessage, RuleKey key, InputComponent fileOrProject, @Nullable Double cost) {
        Objects.requireNonNull(this.context);
        JavaIssue issue = JavaIssue.create(this.context, key, cost);
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        if (textSpan == null) {
            issue.setPrimaryLocationOnComponent(fileOrProject, analyzerMessage.getMessage());
        } else {
            if (!textSpan.onLine()) {
                Preconditions.checkState((!textSpan.isEmpty() ? 1 : 0) != 0, (Object)"Issue location should not be empty");
            }
            issue.setPrimaryLocation((InputFile)fileOrProject, analyzerMessage.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        if (!analyzerMessage.flows.isEmpty()) {
            issue.addFlow((InputFile)analyzerMessage.getInputComponent(), analyzerMessage.flows);
        }
        issue.save();
    }

    public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
        this.reportAnalysisError(inputFile, re.getMessage());
        return this.isSonarLintContext();
    }

    private void reportAnalysisError(InputFile inputFile, String message) {
        this.context.newAnalysisError().onFile(inputFile).message(message).save();
    }

    public boolean isSonarLintContext() {
        return this.context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    public List<String> fileLines(InputFile inputFile) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
        }
        return lines;
    }

    public String inputFileContents(InputFile inputFile) {
        try {
            return inputFile.contents();
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
        }
    }

    public boolean analysisCancelled() {
        return this.context.isCancelled();
    }

    public boolean shouldFailAnalysisOnException() {
        return this.context.config().getBoolean(FAIL_ON_EXCEPTION_KEY).orElse(false);
    }

    public File workDir() {
        ProjectDefinition current = this.projectDefinition;
        if (current == null) {
            return this.fs.workDir();
        }
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current.getWorkDir();
    }

    public InputComponent project() {
        return this.context.module();
    }
}

