/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.Location;
import org.sonar.plugins.java.api.tree.LiteralTree;

public class RegexSource {
    private final List<LiteralTree> stringLiterals;
    private final String sourceText;
    private final TreeMap<Integer, Integer> indices;

    public RegexSource(List<LiteralTree> stringLiterals) {
        this.stringLiterals = stringLiterals;
        this.sourceText = stringLiterals.stream().map(RegexSource::getString).collect(Collectors.joining());
        this.indices = new TreeMap();
        int currentSourceIndex = 0;
        int currentLiteralIndex = 0;
        for (LiteralTree string : stringLiterals) {
            this.indices.put(currentSourceIndex, currentLiteralIndex);
            currentSourceIndex += string.value().length() - 2;
            ++currentLiteralIndex;
        }
    }

    public String substringAt(IndexRange range) {
        return this.sourceText.substring(range.getBeginningOffset(), range.getEndingOffset());
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public int length() {
        return this.sourceText.length();
    }

    List<LiteralTree> getStringLiterals() {
        return Collections.unmodifiableList(this.stringLiterals);
    }

    public List<Location> locationsFor(IndexRange range) {
        return this.locationsFor(range.getBeginningOffset(), range.getEndingOffset());
    }

    public List<Location> locationsFor(int beginningOffset, int endingOffset) {
        ArrayList<Location> result = new ArrayList<Location>();
        Position startPosition = new Position(beginningOffset);
        Position endPosition = new Position(endingOffset);
        for (int i = startPosition.indexOfLiteral; i <= endPosition.indexOfLiteral; ++i) {
            LiteralTree literal = this.stringLiterals.get(i);
            int length = literal.value().length() - 2;
            int startIndex = startPosition.indexOfLiteral == i ? startPosition.indexInsideLiteral : 0;
            int endIndex = endPosition.indexOfLiteral == i ? endPosition.indexInsideLiteral : length;
            result.add(new Location(literal, startIndex, endIndex));
        }
        return result;
    }

    private static String getString(LiteralTree literal) {
        return literal.asConstant(String.class).orElseThrow(() -> new IllegalArgumentException("Only string literals allowed"));
    }

    private class Position {
        final int indexOfLiteral;
        final int indexInsideLiteral;

        public Position(int sourceIndex) {
            Map.Entry entry = RegexSource.this.indices.floorEntry(sourceIndex);
            this.indexOfLiteral = (Integer)entry.getValue();
            this.indexInsideLiteral = sourceIndex - entry.getKey();
        }
    }
}

