/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.Nullable;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class EscapedCharacterClassTree
extends RegexTree {
    private final char type;
    @Nullable
    private final String property;

    private EscapedCharacterClassTree(RegexSource source, IndexRange range, JavaCharacter marker, @Nullable String property) {
        super(source, range);
        this.type = marker.getCharacter();
        this.property = property;
    }

    public EscapedCharacterClassTree(RegexSource source, JavaCharacter backslash, JavaCharacter marker, JavaCharacter openingCurlyBrace, JavaCharacter closingCurlyBrace) {
        this(source, backslash.getRange().merge(closingCurlyBrace.getRange()), marker, source.substringAt(new IndexRange(openingCurlyBrace.getRange().getBeginningOffset() + 1, closingCurlyBrace.getRange().getBeginningOffset())));
        if (!this.isProperty()) {
            throw new IllegalArgumentException("Only \\p can have a property string");
        }
    }

    public EscapedCharacterClassTree(RegexSource source, JavaCharacter backslash, JavaCharacter marker) {
        this(source, backslash.getRange().merge(marker.getRange()), marker, null);
        if (this.isProperty()) {
            throw new IllegalArgumentException("\\p needs a property string");
        }
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitEscapedCharacterClass(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.ESCAPED_CHARACTER_CLASS;
    }

    public boolean isNegation() {
        return Character.isUpperCase(this.type);
    }

    public boolean isProperty() {
        return Character.toLowerCase(this.getType()) == 'p';
    }

    @Nullable
    public String property() {
        return this.property;
    }

    public char getType() {
        return this.type;
    }
}

