/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.regex.RegexLexer;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.SyntaxError;
import org.sonar.java.regex.ast.AtomicGroupTree;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.BoundaryTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.CharacterClassIntersectionTree;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.CharacterClassUnionTree;
import org.sonar.java.regex.ast.CharacterRangeTree;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.CurlyBraceQuantifier;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.DotTree;
import org.sonar.java.regex.ast.EscapedCharacterClassTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.MiscEscapeSequenceTree;
import org.sonar.java.regex.ast.NonCapturingGroupTree;
import org.sonar.java.regex.ast.PlainCharacterTree;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexToken;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.java.regex.ast.SimpleQuantifier;
import org.sonar.java.regex.ast.UnicodeCodePointTree;

public class RegexParser {
    private static final String HEX_DIGIT = "hexadecimal digit";
    private final RegexSource source;
    private final RegexLexer characters;
    private final FlagSet initialFlags;
    private final List<SyntaxError> errors = new ArrayList<SyntaxError>();
    private int groupNumber = 1;

    public RegexParser(RegexSource source, FlagSet initialFlags) {
        this.source = source;
        this.characters = new RegexLexer(source);
        this.characters.setFreeSpacingMode(initialFlags.contains(4));
        this.initialFlags = initialFlags;
    }

    public RegexParseResult parse() {
        RegexTree result;
        ArrayList<RegexTree> results = new ArrayList<RegexTree>();
        do {
            result = this.parseDisjunction();
            results.add(result);
            if (!this.characters.isNotAtEnd()) continue;
            this.error("Unexpected '" + this.characters.getCurrent().getCharacter() + "'");
            this.characters.moveNext();
        } while (this.characters.isNotAtEnd());
        if (this.characters.isInQuotingMode()) {
            this.expected("'\\E'");
        }
        result = RegexParser.combineTrees(results, (range, elements) -> new SequenceTree(this.source, range, elements));
        return new RegexParseResult(result, this.initialFlags, this.errors, this.characters.hasComments());
    }

    private RegexTree parseDisjunction() {
        ArrayList<RegexTree> alternatives = new ArrayList<RegexTree>();
        ArrayList<JavaCharacter> orOperators = new ArrayList<JavaCharacter>();
        RegexTree first = this.parseSequence();
        alternatives.add(first);
        while (this.characters.currentIs('|')) {
            orOperators.add(this.characters.getCurrent());
            this.characters.moveNext();
            RegexTree next = this.parseSequence();
            alternatives.add(next);
        }
        return RegexParser.combineTrees(alternatives, (range, elements) -> new DisjunctionTree(this.source, range, elements, orOperators));
    }

    private RegexTree parseSequence() {
        ArrayList<RegexTree> elements = new ArrayList<RegexTree>();
        RegexTree element = this.parseRepetition();
        while (element != null) {
            elements.add(element);
            element = this.parseRepetition();
        }
        if (elements.isEmpty()) {
            int index = this.characters.getCurrentStartIndex();
            return new SequenceTree(this.source, new IndexRange(index, index), elements);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new SequenceTree(this.source, range, items));
    }

    @CheckForNull
    private RegexTree parseRepetition() {
        RegexTree element = this.parsePrimaryExpression();
        if (this.characters.isInQuotingMode()) {
            return element;
        }
        Quantifier quantifier = this.parseQuantifier();
        if (element == null) {
            if (quantifier != null) {
                this.errors.add(new SyntaxError(quantifier, "Unexpected quantifier '" + quantifier.getText() + "'"));
            }
            return null;
        }
        if (quantifier == null) {
            return element;
        }
        return new RepetitionTree(this.source, element.getRange().merge(quantifier.getRange()), element, quantifier);
    }

    @CheckForNull
    private Quantifier parseQuantifier() {
        SimpleQuantifier.Kind kind;
        switch (this.characters.getCurrentChar()) {
            case 42: {
                kind = SimpleQuantifier.Kind.STAR;
                break;
            }
            case 43: {
                kind = SimpleQuantifier.Kind.PLUS;
                break;
            }
            case 63: {
                kind = SimpleQuantifier.Kind.QUESTION_MARK;
                break;
            }
            case 123: {
                return this.parseCurlyBraceQuantifier();
            }
            default: {
                return null;
            }
        }
        JavaCharacter current = this.characters.getCurrent();
        this.characters.moveNext();
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = current.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new SimpleQuantifier(this.source, range, modifier, kind);
    }

    CurlyBraceQuantifier parseCurlyBraceQuantifier() {
        JavaCharacter openingBrace = this.characters.getCurrent();
        this.characters.moveNext();
        RegexToken lowerBound = this.parseInteger();
        if (lowerBound == null) {
            this.expected("integer");
            return null;
        }
        RegexToken comma = null;
        RegexToken upperBound = null;
        if (this.characters.currentIs(',')) {
            comma = new RegexToken(this.source, this.characters.getCurrent().getRange());
            this.characters.moveNext();
            upperBound = this.parseInteger();
        }
        if (this.characters.currentIs('}')) {
            this.characters.moveNext();
        } else if (comma == null) {
            this.expected("',' or '}'");
        } else if (upperBound == null) {
            this.expected("integer or '}'");
        } else {
            this.expected("'}'");
        }
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = openingBrace.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CurlyBraceQuantifier(this.source, range, modifier, lowerBound, comma, upperBound);
    }

    Quantifier.Modifier parseQuantifierModifier() {
        switch (this.characters.getCurrentChar()) {
            case 43: {
                this.characters.moveNext();
                return Quantifier.Modifier.POSSESSIVE;
            }
            case 63: {
                this.characters.moveNext();
                return Quantifier.Modifier.RELUCTANT;
            }
        }
        return Quantifier.Modifier.GREEDY;
    }

    @CheckForNull
    private RegexToken parseInteger() {
        int startIndex = this.characters.getCurrentStartIndex();
        if (!RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            return null;
        }
        while (RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            this.characters.moveNext();
        }
        IndexRange range = new IndexRange(startIndex, this.characters.getCurrentStartIndex());
        return new RegexToken(this.source, range);
    }

    @CheckForNull
    private RegexTree parsePrimaryExpression() {
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readPlainCharacter();
        }
        switch (this.characters.getCurrentChar()) {
            case 40: {
                return this.parseGroup();
            }
            case 92: {
                return this.parseEscapeSequence();
            }
            case 91: {
                return this.parseCharacterClass();
            }
            case 46: {
                DotTree tree = new DotTree(this.source, this.characters.getCurrentIndexRange());
                this.characters.moveNext();
                return tree;
            }
            case 94: {
                BoundaryTree lineStart = new BoundaryTree(this.source, BoundaryTree.Type.LINE_START, this.characters.getCurrentIndexRange());
                this.characters.moveNext();
                return lineStart;
            }
            case 36: {
                BoundaryTree lineEnd = new BoundaryTree(this.source, BoundaryTree.Type.LINE_END, this.characters.getCurrentIndexRange());
                this.characters.moveNext();
                return lineEnd;
            }
        }
        if (RegexParser.isPlainTextCharacter(this.characters.getCurrentChar())) {
            return this.readPlainCharacter();
        }
        return null;
    }

    private PlainCharacterTree readPlainCharacter() {
        JavaCharacter character = this.characters.getCurrent();
        this.characters.moveNext();
        return this.plainCharacter(character);
    }

    private GroupTree parseGroup() {
        JavaCharacter openingParen = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.currentIs("?=")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookAhead(this.source, range, inner));
        }
        if (this.characters.currentIs("?<=")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookBehind(this.source, range, inner));
        }
        if (this.characters.currentIs("?!")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookAhead(this.source, range, inner));
        }
        if (this.characters.currentIs("?<!")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookBehind(this.source, range, inner));
        }
        if (this.characters.currentIs("?>")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> new AtomicGroupTree(this.source, range, inner));
        }
        if (this.characters.currentIs("?<")) {
            this.characters.moveNext(2);
            String name = this.parseGroupName();
            if (this.characters.currentIs('>')) {
                this.characters.moveNext();
            } else {
                this.expected("'>'");
            }
            return this.finishGroup(openingParen, this.newCapturingGroup(name));
        }
        if (this.characters.currentIs("?")) {
            return this.parseNonCapturingGroup(openingParen);
        }
        return this.finishGroup(openingParen, this.newCapturingGroup(null));
    }

    private GroupConstructor newCapturingGroup(@Nullable String name) {
        int index = this.groupNumber++;
        return (range, inner) -> new CapturingGroupTree(this.source, range, name, index, inner);
    }

    private String parseGroupName() {
        StringBuilder sb = new StringBuilder();
        while (this.characters.isNotAtEnd() && !this.characters.currentIs('>')) {
            sb.append(this.characters.getCurrent().getCharacter());
            this.characters.moveNext();
        }
        String name = sb.toString();
        if (name.isEmpty()) {
            this.expected("a name for the group");
        }
        return name;
    }

    private GroupTree parseNonCapturingGroup(JavaCharacter openingParen) {
        FlagSet disabledFlags;
        this.characters.moveNext();
        FlagSet enabledFlags = this.parseFlags();
        if (this.characters.currentIs('-')) {
            this.characters.moveNext();
            disabledFlags = this.parseFlags();
        } else {
            disabledFlags = new FlagSet();
        }
        boolean previousFreeSpacingMode = this.characters.getFreeSpacingMode();
        if (disabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(false);
        } else if (enabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(true);
        }
        if (this.characters.currentIs(')')) {
            JavaCharacter closingParen = this.characters.getCurrent();
            this.characters.moveNext();
            IndexRange range2 = openingParen.getRange().merge(closingParen.getRange());
            return new NonCapturingGroupTree(this.source, range2, enabledFlags, disabledFlags, null);
        }
        if (this.characters.currentIs(':')) {
            this.characters.moveNext();
        } else {
            this.expected("flag or ':' or ')'");
        }
        return this.finishGroup(previousFreeSpacingMode, openingParen, (range, inner) -> new NonCapturingGroupTree(this.source, range, enabledFlags, disabledFlags, inner));
    }

    private FlagSet parseFlags() {
        Integer flag;
        FlagSet flags = new FlagSet();
        while (this.characters.isNotAtEnd() && (flag = RegexParser.parseFlag(this.characters.getCurrent().getCharacter())) != null) {
            flags.add(flag, this.characters.getCurrent());
            this.characters.moveNext();
        }
        return flags;
    }

    @CheckForNull
    private static Integer parseFlag(char ch) {
        switch (ch) {
            case 'i': {
                return 2;
            }
            case 'd': {
                return 1;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'u': {
                return 64;
            }
            case 'x': {
                return 4;
            }
            case 'U': {
                return 256;
            }
        }
        return null;
    }

    private GroupTree finishGroup(JavaCharacter openingParen, GroupConstructor groupConstructor) {
        return this.finishGroup(this.characters.getFreeSpacingMode(), openingParen, groupConstructor);
    }

    private GroupTree finishGroup(boolean previousFreeSpacingMode, JavaCharacter openingParen, GroupConstructor groupConstructor) {
        RegexTree inner = this.parseDisjunction();
        this.characters.setFreeSpacingMode(previousFreeSpacingMode);
        if (this.characters.currentIs(')')) {
            this.characters.moveNext();
        } else {
            this.expected("')'");
        }
        IndexRange range = openingParen.getRange().extendTo(this.characters.getCurrentStartIndex());
        return groupConstructor.construct(range, inner);
    }

    private RegexTree parseEscapeSequence() {
        JavaCharacter backslash = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.plainCharacter(backslash);
        }
        JavaCharacter character = this.characters.getCurrent();
        switch (character.getCharacter()) {
            case 'P': 
            case 'p': {
                return this.parseEscapedProperty(backslash);
            }
            case '0': {
                return this.parseOctalEscape(backslash);
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumericalBackReference(backslash);
            }
            case 'k': {
                return this.parseNamedBackReference(backslash);
            }
            case 'A': 
            case 'B': 
            case 'G': 
            case 'Z': 
            case 'b': 
            case 'z': {
                return this.parseBoundary(backslash);
            }
            case 'D': 
            case 'H': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 's': 
            case 'v': 
            case 'w': {
                return this.parseEscapedCharacterClass(backslash);
            }
            case 'u': {
                return this.parseUnicodeEscape(backslash);
            }
            case 'x': {
                return this.parseHexEscape(backslash);
            }
            case 'a': 
            case 'e': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                this.characters.moveNext();
                char c = RegexParser.simpleEscapeToCharacter(character.getCharacter());
                IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
                return this.plainCharacter(new JavaCharacter(this.source, range, c, true));
            }
            case 'c': {
                return this.parseControlSequence(backslash);
            }
            case 'N': {
                return this.parseNamedUnicodeCharacter(backslash);
            }
            case 'R': 
            case 'X': {
                this.characters.moveNext();
                return new MiscEscapeSequenceTree(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()));
            }
            case 'E': {
                this.error("\\E used without \\Q");
            }
        }
        this.characters.moveNext();
        return new PlainCharacterTree(this.source, backslash.getRange().merge(character.getRange()), character);
    }

    private RegexTree parseNamedUnicodeCharacter(JavaCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a Unicode character name", content -> new MiscEscapeSequenceTree(this.source, backslash.getRange().merge(((EscapedSequenceDataHolder)content).closer.getRange())));
    }

    private RegexTree parseControlSequence(JavaCharacter backslash) {
        JavaCharacter c = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.plainCharacter(c);
        }
        char controlCharacter = (char)(0x40 ^ this.characters.getCurrentChar());
        this.characters.moveNext();
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.plainCharacter(new JavaCharacter(this.source, range, controlCharacter, true));
    }

    private static char simpleEscapeToCharacter(char escapeCharacter) {
        switch (escapeCharacter) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        throw new IllegalArgumentException("Unsupported argument for simpleEscapeToCharacter: " + escapeCharacter);
    }

    private RegexTree parseUnicodeEscape(JavaCharacter backslash) {
        this.characters.moveNext();
        char codeUnit = (char)this.parseFixedAmountOfHexDigits(4);
        return this.plainCharacter(new JavaCharacter(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), codeUnit, true));
    }

    private RegexTree parseHexEscape(JavaCharacter backslash) {
        this.characters.moveNext();
        int codePoint = 0;
        if (this.characters.currentIs('{')) {
            this.characters.moveNext();
            if (!RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                this.expected(HEX_DIGIT);
            }
            while (RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                codePoint *= 16;
                codePoint += this.parseHexDigit();
            }
            if (this.characters.currentIs('}')) {
                this.characters.moveNext();
            } else {
                this.expected("hexadecimal digit or '}'");
            }
        } else {
            codePoint = this.parseFixedAmountOfHexDigits(2);
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        UnicodeCodePointTree tree = new UnicodeCodePointTree(this.source, range, codePoint);
        if (!Character.isValidCodePoint(codePoint)) {
            this.errors.add(new SyntaxError(tree, "Invalid Unicode code point"));
        }
        return tree;
    }

    private int parseFixedAmountOfHexDigits(int amount) {
        int i;
        int result = 0;
        for (i = 0; i < amount && RegexParser.isHexDigit(this.characters.getCurrentChar()); ++i) {
            result = (char)(result * 16);
            result = (char)(result + this.parseHexDigit());
        }
        if (i < amount) {
            this.expected(HEX_DIGIT);
        }
        return result;
    }

    private int parseHexDigit() {
        int value = Integer.parseInt("" + this.characters.getCurrent().getCharacter(), 16);
        this.characters.moveNext();
        return value;
    }

    private RegexTree parseEscapedCharacterClass(JavaCharacter backslash) {
        EscapedCharacterClassTree result = new EscapedCharacterClassTree(this.source, backslash, this.characters.getCurrent());
        this.characters.moveNext();
        return result;
    }

    private RegexTree parseEscapedProperty(JavaCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a property name", dh -> new EscapedCharacterClassTree(this.source, backslash, ((EscapedSequenceDataHolder)dh).marker, ((EscapedSequenceDataHolder)dh).opener, ((EscapedSequenceDataHolder)dh).closer));
    }

    private RegexTree parseNamedBackReference(JavaCharacter backslash) {
        return this.parseEscapedSequence('<', '>', "a group name", dh -> new BackReferenceTree(this.source, backslash, ((EscapedSequenceDataHolder)dh).marker, ((EscapedSequenceDataHolder)dh).opener, ((EscapedSequenceDataHolder)dh).closer));
    }

    private RegexTree parseEscapedSequence(char opener, char closer, String expected, Function<EscapedSequenceDataHolder, RegexTree> builder) {
        JavaCharacter marker = this.characters.getCurrent();
        this.characters.moveNext();
        if (!this.characters.currentIs(opener)) {
            this.expected("'" + opener + "'");
            return this.plainCharacter(marker);
        }
        JavaCharacter openerChar = this.characters.getCurrent();
        boolean atLeastOneChar = false;
        do {
            this.characters.moveNext();
            if (this.characters.isAtEnd()) {
                this.expected(atLeastOneChar ? "'" + closer + "'" : expected);
                return this.plainCharacter(openerChar);
            }
            if (!atLeastOneChar && this.characters.currentIs(closer)) {
                this.expected(expected);
                return this.plainCharacter(openerChar);
            }
            atLeastOneChar = true;
        } while (!this.characters.currentIs(closer));
        JavaCharacter closerChar = this.characters.getCurrent();
        this.characters.moveNext();
        return builder.apply(new EscapedSequenceDataHolder(marker, openerChar, closerChar));
    }

    private RegexTree parseNumericalBackReference(JavaCharacter backslash) {
        JavaCharacter firstDigit;
        JavaCharacter lastDigit = firstDigit = this.characters.getCurrent();
        do {
            this.characters.moveNext();
            if (this.characters.isAtEnd()) continue;
            JavaCharacter currentChar = this.characters.getCurrent();
            char asChar = currentChar.getCharacter();
            if (!RegexParser.isAsciiDigit(asChar)) break;
            lastDigit = currentChar;
        } while (!this.characters.isAtEnd());
        return new BackReferenceTree(this.source, backslash, null, firstDigit, lastDigit);
    }

    private RegexTree parseOctalEscape(JavaCharacter backslash) {
        int newValue;
        int i;
        this.characters.moveNext();
        char byteValue = '\u0000';
        for (i = 0; i < 3 && RegexParser.isOctalDigit(this.characters.getCurrentChar()) && (newValue = byteValue * 8 + this.characters.getCurrentChar() - 48) <= 255; ++i) {
            byteValue = (char)newValue;
            this.characters.moveNext();
        }
        if (i == 0) {
            this.expected("octal digit");
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.plainCharacter(new JavaCharacter(this.source, range, byteValue, true));
    }

    private RegexTree parseBoundary(JavaCharacter backslash) {
        if (this.characters.currentIs("b{")) {
            return this.parseEscapedSequence('{', '}', "an Unicode extended grapheme cluster", dh -> new BoundaryTree(this.source, BoundaryTree.Type.UNICODE_EXTENDED_GRAPHEME_CLUSTER, backslash.getRange().merge(((EscapedSequenceDataHolder)dh).closer.getRange())));
        }
        JavaCharacter boundary = this.characters.getCurrent();
        this.characters.moveNext();
        return new BoundaryTree(this.source, BoundaryTree.Type.forKey(boundary.getCharacter()), backslash.getRange().merge(boundary.getRange()));
    }

    private RegexTree parseCharacterClass() {
        JavaCharacter openingBracket = this.characters.getCurrent();
        this.characters.moveNext();
        boolean negated = false;
        if (this.characters.currentIs('^')) {
            this.characters.moveNext();
            negated = true;
        }
        RegexTree contents = this.parseCharacterClassIntersection();
        if (this.characters.currentIs(']')) {
            this.characters.moveNext();
        } else {
            this.expected("']'");
        }
        IndexRange range = openingBracket.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CharacterClassTree(this.source, range, openingBracket, negated, contents);
    }

    private RegexTree parseCharacterClassIntersection() {
        ArrayList<RegexTree> elements = new ArrayList<RegexTree>();
        ArrayList<RegexToken> andOperators = new ArrayList<RegexToken>();
        elements.add(this.parseCharacterClassUnion(true));
        while (this.characters.currentIs("&&")) {
            JavaCharacter firstAnd = this.characters.getCurrent();
            this.characters.moveNext();
            JavaCharacter secondAnd = this.characters.getCurrent();
            this.characters.moveNext();
            andOperators.add(new RegexToken(this.source, firstAnd.getRange().merge(secondAnd.getRange())));
            elements.add(this.parseCharacterClassUnion(false));
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassIntersectionTree(this.source, range, items, andOperators));
    }

    private RegexTree parseCharacterClassUnion(boolean isAtBeginning) {
        ArrayList<RegexTree> elements = new ArrayList<RegexTree>();
        RegexTree element = this.parseCharacterClassElement(isAtBeginning);
        while (element != null) {
            elements.add(element);
            element = this.parseCharacterClassElement(false);
        }
        if (elements.isEmpty()) {
            IndexRange range2 = new IndexRange(this.characters.getCurrentStartIndex(), this.characters.getCurrentStartIndex());
            return new CharacterClassUnionTree(this.source, range2, elements);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassUnionTree(this.source, range, items));
    }

    @CheckForNull
    private RegexTree parseCharacterClassElement(boolean isAtBeginning) {
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readPlainCharacter();
        }
        if (this.characters.isAtEnd() || this.characters.currentIs("&&")) {
            return null;
        }
        JavaCharacter startCharacter = this.characters.getCurrent();
        switch (startCharacter.getCharacter()) {
            case '\\': {
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.PLAIN_CHARACTER, RegexTree.Kind.UNICODE_CODE_POINT)) {
                    return this.parseCharacterRange((CharacterTree)escape);
                }
                return escape;
            }
            case '[': {
                return this.parseCharacterClass();
            }
            case ']': {
                if (isAtBeginning) {
                    this.characters.moveNext();
                    return this.parseCharacterRange(this.plainCharacter(startCharacter));
                }
                return null;
            }
        }
        this.characters.moveNext();
        return this.parseCharacterRange(this.plainCharacter(startCharacter));
    }

    private RegexTree parseCharacterRange(CharacterTree startCharacter) {
        if (this.characters.currentIs('-') && !this.characters.isInQuotingMode()) {
            int lookAhead = this.characters.lookAhead(1);
            if (lookAhead == -1 || lookAhead == 93) {
                return startCharacter;
            }
            if (lookAhead == 92) {
                this.characters.moveNext();
                JavaCharacter backslash = this.characters.getCurrent();
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.PLAIN_CHARACTER, RegexTree.Kind.UNICODE_CODE_POINT)) {
                    return this.characterRange(startCharacter, (CharacterTree)escape);
                }
                this.expected("simple character", escape);
                return this.characterRange(startCharacter, this.plainCharacter(backslash));
            }
            this.characters.moveNext();
            JavaCharacter endCharacter = this.characters.getCurrent();
            this.characters.moveNext();
            return this.characterRange(startCharacter, this.plainCharacter(endCharacter));
        }
        return startCharacter;
    }

    private PlainCharacterTree plainCharacter(JavaCharacter character) {
        return this.plainCharacter(character, character.getRange());
    }

    private PlainCharacterTree plainCharacter(JavaCharacter character, IndexRange range) {
        return new PlainCharacterTree(this.source, range, character);
    }

    private CharacterRangeTree characterRange(CharacterTree startCharacter, CharacterTree endCharacter) {
        IndexRange range = startCharacter.getRange().merge(endCharacter.getRange());
        CharacterRangeTree characterRange = new CharacterRangeTree(this.source, range, startCharacter, endCharacter);
        if (startCharacter.codePointOrUnit() > endCharacter.codePointOrUnit()) {
            this.errors.add(new SyntaxError(characterRange, "Illegal character range"));
        }
        return characterRange;
    }

    private void expected(String expectedToken, String actual) {
        this.error("Expected " + expectedToken + ", but found " + actual);
    }

    private void expected(String expectedToken, RegexSyntaxElement actual) {
        this.expected(expectedToken, "'" + actual.getText() + "'");
    }

    private void expected(String expectedToken) {
        String actual = this.characters.isAtEnd() ? "the end of the regex" : "'" + this.characters.getCurrent().getCharacter() + "'";
        this.expected(expectedToken, actual);
    }

    private void error(String message) {
        IndexRange range = this.characters.getCurrentIndexRange();
        RegexToken offendingToken = new RegexToken(this.source, range);
        this.errors.add(new SyntaxError(offendingToken, message));
    }

    private static RegexTree combineTrees(List<RegexTree> elements, TreeConstructor treeConstructor) {
        if (elements.size() == 1) {
            return elements.get(0);
        }
        IndexRange range = elements.get(0).getRange().merge(elements.get(elements.size() - 1).getRange());
        return treeConstructor.construct(range, elements);
    }

    private static boolean isAsciiDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHexDigit(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static boolean isPlainTextCharacter(int c) {
        switch (c) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 123: 
            case 124: {
                return false;
            }
        }
        return true;
    }

    private static interface GroupConstructor {
        public GroupTree construct(IndexRange var1, RegexTree var2);
    }

    private static interface TreeConstructor {
        public RegexTree construct(IndexRange var1, List<RegexTree> var2);
    }

    private static final class EscapedSequenceDataHolder {
        private final JavaCharacter marker;
        private final JavaCharacter opener;
        private final JavaCharacter closer;

        private EscapedSequenceDataHolder(JavaCharacter marker, JavaCharacter opener, JavaCharacter closer) {
            this.marker = marker;
            this.opener = opener;
            this.closer = closer;
        }
    }
}

