/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.sonar.java.regex.JavaUnicodeEscapeParser;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.RegexSource;

public class JavaCharacterParser {
    private final RegexSource source;
    private final JavaUnicodeEscapeParser unicodeProcessedCharacters;
    @CheckForNull
    private JavaCharacter current;

    public JavaCharacterParser(RegexSource source) {
        this.source = source;
        this.unicodeProcessedCharacters = new JavaUnicodeEscapeParser(source);
        this.moveNext();
    }

    public void resetTo(int index) {
        this.unicodeProcessedCharacters.resetTo(index);
        this.moveNext();
    }

    public void moveNext() {
        this.current = this.parseJavaCharacter();
    }

    @Nonnull
    public JavaCharacter getCurrent() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public boolean isAtEnd() {
        return this.current == null;
    }

    public boolean isNotAtEnd() {
        return this.current != null;
    }

    @CheckForNull
    private JavaCharacter parseJavaCharacter() {
        JavaCharacter javaCharacter = this.unicodeProcessedCharacters.getCurrent();
        if (javaCharacter == null) {
            return null;
        }
        if (javaCharacter.getCharacter() == '\\') {
            return this.parseJavaEscapeSequence(javaCharacter);
        }
        this.unicodeProcessedCharacters.moveNext();
        return javaCharacter;
    }

    private JavaCharacter parseJavaEscapeSequence(JavaCharacter backslash) {
        this.unicodeProcessedCharacters.moveNext();
        JavaCharacter javaCharacter = this.unicodeProcessedCharacters.getCurrent();
        if (javaCharacter == null) {
            return backslash;
        }
        char ch = javaCharacter.getCharacter();
        switch (ch) {
            case 'n': {
                ch = '\n';
                break;
            }
            case 'r': {
                ch = '\r';
                break;
            }
            case 'f': {
                ch = '\f';
                break;
            }
            case 'b': {
                ch = '\b';
                break;
            }
            case 't': {
                ch = '\t';
                break;
            }
            default: {
                int newValue;
                if (!JavaCharacterParser.isOctalDigit(ch)) break;
                ch = '\u0000';
                for (int i = 0; i < 3 && javaCharacter != null && JavaCharacterParser.isOctalDigit(javaCharacter.getCharacter()) && (newValue = ch * 8 + javaCharacter.getCharacter() - 48) <= 255; ++i) {
                    ch = (char)newValue;
                    this.unicodeProcessedCharacters.moveNext();
                    javaCharacter = this.unicodeProcessedCharacters.getCurrent();
                }
                int endIndex = javaCharacter == null ? this.source.length() : javaCharacter.getRange().getBeginningOffset();
                return new JavaCharacter(this.source, backslash.getRange().extendTo(endIndex), ch, true);
            }
        }
        this.unicodeProcessedCharacters.moveNext();
        return new JavaCharacter(this.source, backslash.getRange().merge(javaCharacter.getRange()), ch, true);
    }

    private static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }
}

