/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class CaseLabelTreeImpl
extends JavaTree
implements CaseLabelTree {
    private final InternalSyntaxToken caseOrDefaultKeyword;
    private final List<ExpressionTree> expressions;
    private final boolean isFallThrough;
    private final InternalSyntaxToken colonOrArrowToken;

    public CaseLabelTreeImpl(InternalSyntaxToken caseOrDefaultKeyword, List<ExpressionTree> expressions, InternalSyntaxToken colonOrArrowToken) {
        this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        this.expressions = expressions;
        this.isFallThrough = JavaPunctuator.COLON.getValue().equals(colonOrArrowToken.text());
        this.colonOrArrowToken = colonOrArrowToken;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.CASE_LABEL;
    }

    @Override
    public SyntaxToken caseOrDefaultKeyword() {
        return this.caseOrDefaultKeyword;
    }

    @Override
    public boolean isFallThrough() {
        return this.isFallThrough;
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expressions.isEmpty() ? null : this.expressions.get(0);
    }

    @Override
    public List<ExpressionTree> expressions() {
        return this.expressions;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonOrArrowToken;
    }

    @Override
    public SyntaxToken colonOrArrowToken() {
        return this.colonOrArrowToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCaseLabel(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Iterables.concat(Collections.singletonList(this.caseOrDefaultKeyword), this.expressions, Collections.singletonList(this.colonOrArrowToken));
    }
}

