/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList) {
        return SyntacticEquivalence.areEquivalent(leftList, rightList, (JavaTree t1, JavaTree t2) -> false);
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList, BiPredicate<JavaTree, JavaTree> permissiveEquivalence) {
        if (leftList.size() != rightList.size()) {
            return false;
        }
        for (int i = 0; i < leftList.size(); ++i) {
            Tree right;
            Tree left = leftList.get(i);
            if (SyntacticEquivalence.areEquivalent(left, right = rightList.get(i), permissiveEquivalence)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode) {
        return SyntacticEquivalence.areEquivalent(leftNode, rightNode, (JavaTree t1, JavaTree t2) -> false);
    }

    @VisibleForTesting
    static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode, BiPredicate<JavaTree, JavaTree> permissiveEquivalence) {
        return SyntacticEquivalence.areEquivalent((JavaTree)leftNode, (JavaTree)rightNode, permissiveEquivalence);
    }

    private static boolean areEquivalent(@Nullable JavaTree leftNode, @Nullable JavaTree rightNode, BiPredicate<JavaTree, JavaTree> permissiveEquivalence) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (permissiveEquivalence.test(leftNode, rightNode)) {
            return true;
        }
        if (leftNode.kind() != rightNode.kind() || leftNode.is(Tree.Kind.OTHER)) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        Iterator<Tree> iteratorA = leftNode.getChildren().iterator();
        Iterator<Tree> iteratorB = rightNode.getChildren().iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next(), permissiveEquivalence)) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    private static boolean areLeafsEquivalent(JavaTree leftNode, JavaTree rightNode) {
        if (leftNode instanceof SyntaxToken) {
            return Objects.equals(((SyntaxToken)((Object)leftNode)).text(), ((SyntaxToken)((Object)rightNode)).text());
        }
        if (leftNode.is(Tree.Kind.INFERED_TYPE)) {
            return rightNode.is(Tree.Kind.INFERED_TYPE);
        }
        throw new IllegalArgumentException();
    }
}

