/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.plugins.java.api.JavaFileScannerContext;

public class Flow {
    private final List<JavaFileScannerContext.Location> elements;
    private boolean exceptional;

    private Flow(List<JavaFileScannerContext.Location> elements, boolean exceptional) {
        this.elements = elements;
        this.exceptional = exceptional;
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.exceptional);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Flow other = (Flow)obj;
        return Objects.equals(this.elements, other.elements) && this.exceptional == other.exceptional;
    }

    public boolean isNonExceptional() {
        return !this.exceptional;
    }

    public Flow reverse() {
        return new Flow(Lists.reverse(this.elements), this.exceptional);
    }

    public Stream<JavaFileScannerContext.Location> stream() {
        return this.elements.stream();
    }

    public Stream<JavaFileScannerContext.Location> firstFlowLocation() {
        return this.elements.stream().reduce((a, b) -> b).map(Stream::of).orElseGet(Stream::empty);
    }

    public List<JavaFileScannerContext.Location> elements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public static Flow empty() {
        return new Flow(Collections.emptyList(), false);
    }

    public static Flow of(JavaFileScannerContext.Location location) {
        return new Flow(Collections.singletonList(Objects.requireNonNull(location)), false);
    }

    public static Flow of(Flow currentFlow) {
        return new Flow((List<JavaFileScannerContext.Location>)ImmutableList.copyOf(currentFlow.elements), currentFlow.exceptional);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<JavaFileScannerContext.Location> elementsBuilder = ImmutableList.builder();
        private boolean exceptional = false;

        private Builder() {
        }

        public Builder setAsExceptional() {
            this.exceptional = true;
            return this;
        }

        public Builder add(JavaFileScannerContext.Location element) {
            this.elementsBuilder.add((Object)element);
            return this;
        }

        public Builder addAll(Flow flow) {
            this.elementsBuilder.addAll((Iterable)flow.elements);
            this.exceptional |= flow.exceptional;
            return this;
        }

        public Flow build() {
            return new Flow((List)this.elementsBuilder.build(), this.exceptional);
        }
    }
}

