/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Type;

@FunctionalInterface
public interface ParametersCriteria
extends Predicate<List<Type>> {
    public static ParametersCriteria none() {
        return List::isEmpty;
    }

    public static ParametersCriteria any() {
        return parameterTypes -> true;
    }

    public static ParametersCriteria of(List<TypeCriteria> expectedTypes) {
        return actualTypes -> ParametersCriteria.matches(expectedTypes, actualTypes);
    }

    public static boolean matches(List<TypeCriteria> expectedTypes, List<Type> actualTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < actualTypes.size(); ++i) {
            if (expectedTypes.get(i).test(actualTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

