/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaFilesCache;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = Loggers.get(DefaultJavaResourceLocator.class);
    private final JavaClasspath javaClasspath;
    @VisibleForTesting
    Map<String, InputFile> resourcesByClass;

    public DefaultJavaResourceLocator(JavaClasspath javaClasspath) {
        this.javaClasspath = javaClasspath;
        this.resourcesByClass = new HashMap<String, InputFile>();
    }

    @Override
    public InputFile findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        InputFile inputFile = this.resourcesByClass.get(name);
        if (inputFile == null) {
            LOG.debug("Class not found in resource cache : {}", (Object)className);
        }
        return inputFile;
    }

    private Collection<String> classKeys() {
        return ImmutableSortedSet.naturalOrder().addAll(this.resourcesByClass.keySet()).build();
    }

    @Override
    public Collection<File> classFilesToAnalyze() {
        ImmutableList.Builder result = ImmutableList.builder();
        block0: for (String key : this.classKeys()) {
            String filePath = key + ".class";
            for (File binaryDir : this.javaClasspath.getBinaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add((Object)classFile);
                continue block0;
            }
        }
        return result.build();
    }

    @Override
    public Collection<File> classpath() {
        return this.javaClasspath.getElements();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        InputFile inputFile = context.getInputFile();
        JavaFilesCache javaFilesCache = new JavaFilesCache();
        javaFilesCache.scanFile(context);
        javaFilesCache.getClassNames().forEach(className -> this.resourcesByClass.put((String)className, inputFile));
    }
}

