/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UnusedPrivateMethod", repositoryKey="squid")
@Rule(key="S1144")
public class UnusedPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    private final List<MethodTree> unusedPrivateMethods = new ArrayList<MethodTree>();
    private final Set<String> unresolvedMethodNames = new HashSet<String>();
    private static final String PARAM_ANNOTATION_EXCEPTION = "javax.enterprise.event.Observes";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE, Tree.Kind.NEW_CLASS);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.reportUnusedPrivateMethods();
        this.unusedPrivateMethods.clear();
        this.unresolvedMethodNames.clear();
    }

    private void reportUnusedPrivateMethods() {
        this.unusedPrivateMethods.stream().filter(methodTree -> !this.unresolvedMethodNames.contains(methodTree.simpleName().name())).forEach(methodTree -> {
            IdentifierTree simpleName = methodTree.simpleName();
            String methodType = methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method";
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)simpleName).withMessage("Remove this unused private \"%s\" %s.", new Object[]{simpleName.name(), methodType}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove the unused %s", (Object[])new Object[]{methodType}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)QuickFixHelper.previousToken((Tree)methodTree), (boolean)false, (Tree)methodTree, (boolean)true))}).build()).report();
        });
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                this.checkIfUnused((MethodTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.checkIfUnknown((NewClassTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.checkIfUnknown((MethodInvocationTree)tree);
                break;
            }
            case METHOD_REFERENCE: {
                this.checkIfUnknown((MethodReferenceTree)tree);
                break;
            }
        }
    }

    private void checkIfUnknown(MethodInvocationTree mit) {
        String name = ExpressionUtils.methodName((MethodInvocationTree)mit).name();
        this.addIfArgumentsAreUnknown(mit.arguments(), name);
        this.addIfUnknownOrAmbiguous((Symbol)mit.methodSymbol(), name);
    }

    private void checkIfUnknown(NewClassTree nct) {
        String name = UnusedPrivateMethodCheck.constructorName(nct.identifier());
        this.addIfArgumentsAreUnknown(nct.arguments(), name);
        this.addIfUnknownOrAmbiguous((Symbol)nct.methodSymbol(), name);
    }

    private void checkIfUnknown(MethodReferenceTree mref) {
        IdentifierTree methodIdentifier = mref.method();
        this.addIfUnknownOrAmbiguous(methodIdentifier.symbol(), methodIdentifier.name());
    }

    private void addIfArgumentsAreUnknown(Arguments arguments, String name) {
        if (arguments.stream().anyMatch(arg -> arg.symbolType().isUnknown())) {
            this.unresolvedMethodNames.add(name);
        }
    }

    private void addIfUnknownOrAmbiguous(Symbol symbol, String name) {
        if (symbol.isUnknown() || symbol.isMethodSymbol() && ((Symbol.MethodSymbol)symbol).parameterTypes().stream().anyMatch(Type::isUnknown)) {
            this.unresolvedMethodNames.add(name);
        }
    }

    private static String constructorName(TypeTree typeTree) {
        switch (typeTree.kind()) {
            case PARAMETERIZED_TYPE: {
                return UnusedPrivateMethodCheck.constructorName(((ParameterizedTypeTree)typeTree).type());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectExpressionTree)typeTree).identifier().name();
            }
            case IDENTIFIER: {
                return ((IdentifierTree)typeTree).name();
            }
        }
        throw new IllegalStateException("Unexpected TypeTree used as constructor.");
    }

    private void checkIfUnused(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (UnusedPrivateMethodCheck.isUnusedPrivate((Symbol)symbol) && UnusedPrivateMethodCheck.hasNoAnnotation(methodTree) && (UnusedPrivateMethodCheck.isConstructorWithParameters(methodTree) || UnusedPrivateMethodCheck.isNotMethodFromSerializable(methodTree, (Symbol)symbol))) {
            this.unusedPrivateMethods.add(methodTree);
        }
    }

    private static boolean isUnusedPrivate(Symbol symbol) {
        return symbol.isPrivate() && symbol.usages().isEmpty();
    }

    private static boolean hasNoAnnotation(MethodTree methodTree) {
        return methodTree.modifiers().annotations().isEmpty() && methodTree.parameters().stream().noneMatch(UnusedPrivateMethodCheck::hasAllowedAnnotation);
    }

    private static boolean hasAllowedAnnotation(VariableTree variableTree) {
        List annotations = variableTree.modifiers().annotations();
        return !annotations.isEmpty() && annotations.stream().anyMatch(UnusedPrivateMethodCheck::isAllowedAnnotation);
    }

    private static boolean isAllowedAnnotation(AnnotationTree annotation) {
        Type annotationSymbolType = annotation.symbolType();
        if (annotationSymbolType.is(PARAM_ANNOTATION_EXCEPTION)) {
            return true;
        }
        if (annotationSymbolType.isUnknown()) {
            TypeTree annotationType = annotation.annotationType();
            if (annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return "Observes".equals(((IdentifierTree)annotationType).name());
            }
            if (annotationType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return PARAM_ANNOTATION_EXCEPTION.equals(ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)annotationType)));
            }
        }
        return false;
    }

    private static boolean isConstructorWithParameters(MethodTree methodTree) {
        return methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !methodTree.parameters().isEmpty();
    }

    private static boolean isNotMethodFromSerializable(MethodTree methodTree, Symbol symbol) {
        return methodTree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !SerializableContract.SERIALIZABLE_CONTRACT_METHODS.contains(symbol.name());
    }
}

