/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3436")
public class ValueBasedObjectUsedForLockCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final List<String> VALUE_BASED_TYPES = Arrays.asList("java.time.chrono.HijrahDate", "java.time.chrono.JapaneseDate", "java.time.chrono.MinguoDate", "java.time.chrono.ThaiBuddhistDate", "java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalLong", "java.util.OptionalInt");
    private static final String JAVA_TIME_CLOCK = "java.time.Clock";
    private static final Pattern JAVA_TIME_PACKAGE_PATTERN = Pattern.compile("java\\.time\\.\\w+");

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree expression = ((SynchronizedStatementTree)tree).expression();
        Type expressionType = expression.symbolType();
        if (ValueBasedObjectUsedForLockCheck.isValueBasedType(expressionType)) {
            this.reportIssue((Tree)expression, String.format("Synchronize on a non-value-based object; synchronizing on a \"%s\" could lead to contention.%s", expressionType.name(), this.context.getJavaVersion().java8CompatibilityMessage()));
        }
    }

    private static boolean isValueBasedType(Type type) {
        if (type.isUnknown() || type.is(JAVA_TIME_CLOCK)) {
            return false;
        }
        return VALUE_BASED_TYPES.stream().anyMatch(arg_0 -> ((Type)type).is(arg_0)) || JAVA_TIME_PACKAGE_PATTERN.matcher(type.fullyQualifiedName()).matches();
    }
}

