/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5320")
public class AndroidBroadcastingCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that broadcasting intents is safe here.";
    private static final MethodMatchers SEND_BROADCAST = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendBroadcast"}).withAnyParameters().build();
    private static final MethodMatchers SEND_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendBroadcastAsUser"}).withAnyParameters().build();
    private static final MethodMatchers SEND_ORDERED_BROADCAST = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendOrderedBroadcast"}).withAnyParameters().build();
    private static final MethodMatchers SEND_ORDERED_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendOrderedBroadcastAsUser"}).withAnyParameters().build();
    private static final MethodMatchers SEND_STICKY_BROADCAST = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendStickyBroadcast"}).withAnyParameters().build();
    private static final MethodMatchers SEND_STICKY_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendStickyBroadcastAsUser"}).withAnyParameters().build();
    private static final MethodMatchers SEND_STICKY_ORDERED_BROADCAST = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendStickyOrderedBroadcast"}).withAnyParameters().build();
    private static final MethodMatchers SEND_STICKY_ORDERED_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().names(new String[]{"sendStickyOrderedBroadcastAsUser"}).withAnyParameters().build();
    private static final MethodMatchers STICKY_BROADCAST = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{SEND_STICKY_BROADCAST, SEND_STICKY_BROADCAST_AS_USER, SEND_STICKY_ORDERED_BROADCAST, SEND_STICKY_ORDERED_BROADCAST_AS_USER});

    private static MethodMatchers.NameBuilder androidContext() {
        return MethodMatchers.create().ofSubTypes(new String[]{"android.content.Context"});
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{SEND_BROADCAST, SEND_BROADCAST_AS_USER, SEND_ORDERED_BROADCAST, SEND_ORDERED_BROADCAST_AS_USER, SEND_STICKY_BROADCAST, SEND_STICKY_BROADCAST_AS_USER, SEND_STICKY_ORDERED_BROADCAST, SEND_STICKY_ORDERED_BROADCAST_AS_USER});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (AndroidBroadcastingCheck.isSendBroadcast(mit) || AndroidBroadcastingCheck.isSendBroadcastAsUser(mit) || AndroidBroadcastingCheck.isSendOrderedBroadcast(mit) || AndroidBroadcastingCheck.isSendOrderedBroadcastAsUser(mit) || STICKY_BROADCAST.matches(mit)) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        }
    }

    private static boolean isSendBroadcast(MethodInvocationTree mit) {
        return SEND_BROADCAST.matches(mit) && (mit.arguments().size() < 2 || ((ExpressionTree)mit.arguments().get(1)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}));
    }

    private static boolean isSendBroadcastAsUser(MethodInvocationTree mit) {
        return SEND_BROADCAST_AS_USER.matches(mit) && (mit.arguments().size() < 3 || ((ExpressionTree)mit.arguments().get(2)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}));
    }

    private static boolean isSendOrderedBroadcast(MethodInvocationTree mit) {
        return SEND_ORDERED_BROADCAST.matches(mit) && mit.arguments().size() > 1 && ((ExpressionTree)mit.arguments().get(1)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private static boolean isSendOrderedBroadcastAsUser(MethodInvocationTree mit) {
        return SEND_ORDERED_BROADCAST_AS_USER.matches(mit) && mit.arguments().size() > 2 && ((ExpressionTree)mit.arguments().get(2)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }
}

