/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4174")
public class BadLocalConstantNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    @RuleProperty(key="format", description="Regular expression used to check the constant names against.", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    public String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;

    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        Symbol symbol = variableTree.symbol();
        if (!symbol.owner().isMethodSymbol() || !symbol.isFinal()) {
            return;
        }
        if (!BadLocalConstantNameCheck.hasLiteralInitializer(variableTree.initializer())) {
            return;
        }
        IdentifierTree simpleName = variableTree.simpleName();
        if (!this.pattern.matcher(simpleName.name()).matches()) {
            this.reportIssue((Tree)simpleName, "Rename this constant name to match the regular expression '" + this.format + "'.");
        }
    }

    private static boolean hasLiteralInitializer(@Nullable ExpressionTree initializer) {
        return initializer != null && ExpressionUtils.skipParentheses((ExpressionTree)initializer).is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.STRING_LITERAL});
    }
}

