/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6244")
public class AwsConsumerBuilderUsageCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofType(type -> type.fullyQualifiedName().startsWith("software.amazon.awssdk.")).anyName().withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Symbol.MethodSymbol methodSymbol = mit.methodSymbol();
        Symbol parentClass = Optional.ofNullable(methodSymbol.owner()).orElse((Symbol)Symbols.unknownTypeSymbol);
        Symbol.TypeSymbol returnType = methodSymbol.returnType();
        if (!returnType.isUnknown() && "Builder".equals(parentClass.name())) {
            String returnTypeName = returnType.type().fullyQualifiedName();
            if (!returnTypeName.equals(parentClass.type().fullyQualifiedName())) {
                return;
            }
            ExpressionTree arg = AwsConsumerBuilderUsageCheck.getNonConsumerSingleArgument(mit);
            if (arg != null && AwsConsumerBuilderUsageCheck.hasMatchingMethodWithConsumer(parentClass, methodSymbol, returnTypeName, arg.symbolType()) && (AwsConsumerBuilderUsageCheck.isBuilder(arg) || AwsConsumerBuilderUsageCheck.isVariableContainingABuilderResult(arg))) {
                this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Consider using the Consumer Builder method instead of creating this nested builder.");
            }
        }
    }

    private static boolean hasMatchingMethodWithConsumer(Symbol parentClass, Symbol.MethodSymbol methodSymbol, String returnType, Type argType) {
        String consumerTypeArgument = argType.fullyQualifiedName() + "$Builder";
        return ((Symbol.TypeSymbol)parentClass).memberSymbols().stream().anyMatch(symbol -> AwsConsumerBuilderUsageCheck.isMatchingConsumerSingleArgumentMethod(symbol, methodSymbol.name(), returnType, consumerTypeArgument));
    }

    @CheckForNull
    private static ExpressionTree getNonConsumerSingleArgument(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        if (arguments.size() != 1) {
            return null;
        }
        ExpressionTree arg = (ExpressionTree)arguments.get(0);
        Type type = arg.symbolType();
        if (type.isUnknown() || type.is("java.util.function.Consumer")) {
            return null;
        }
        return arg;
    }

    private static boolean isMatchingConsumerSingleArgumentMethod(Symbol symbol, String methodName, String methodReturnType, String consumerTypeArgument) {
        if (!symbol.isMethodSymbol()) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        if (!methodSymbol.name().equals(methodName) || !methodSymbol.returnType().type().fullyQualifiedName().equals(methodReturnType)) {
            return false;
        }
        List parameterTypes = methodSymbol.parameterTypes();
        if (parameterTypes.size() != 1) {
            return false;
        }
        Type parameterType = (Type)parameterTypes.get(0);
        if (!parameterType.is("java.util.function.Consumer")) {
            return false;
        }
        List typeArguments = parameterType.typeArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        Type typeArgument = (Type)typeArguments.get(0);
        return typeArgument.fullyQualifiedName().equals(consumerTypeArgument);
    }

    private static boolean isVariableContainingABuilderResult(ExpressionTree expression) {
        if (!expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return false;
        }
        Symbol variable = ((IdentifierTree)expression).symbol();
        return JUtils.isLocalVariable((Symbol)variable) && ExpressionsHelper.initializedAndAssignedExpressionStream(variable).anyMatch(AwsConsumerBuilderUsageCheck::isBuilder);
    }

    private static boolean isBuilder(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && "build".equals(((MethodInvocationTree)expression).methodSymbol().name());
    }
}

